// warning: line numbers are important here, watch out
using Nemerle.IO;
using Nemerle.Diagnostics;

[Trace (printf ("executing %s:%d:%s () - %s\n", A.g (_file), _line, _method, _expr))]
module B {
  public hoo () : void {
    def x = 6 + 4;
    def y = x * 5;
    print ("$x + $y\n");
    joo ();
  } 

  joo () : void {
    def u = 8 + 2;
    def o = u * 4;
    print ("$u + $o\n");
  }
}

module A
{
  [Trace (printf ("executing %s:%d:%s () - %s\n", g (_file), _line, _method, _expr))]
  public m () : void {
    def x = 2;
    mutable y = 4;
    
    match ((y, x)) {
      | (4, 2) => printf ("good match\n");
      | _ => printf ("bad match\n");
    }
    def _g = (1,2);
    for (mutable i = 0; i < x; ++i) {
      y = x * 3 + y;
      y = 2 * y;
      y *= i;
    }
    y -= 1;
    B.hoo ();
  }

  public g (x : string) : string { 
    x.Substring (x.Length - 7)
  }


  Main () : void {
    m ();
  }
}

/*
BEGIN-OUTPUT
executing trace.n:25:m () - def x = 2
executing trace.n:26:m () - mutable y = 4
executing trace.n:28:m () - match ((y, x)) {
  | (4, 2) => 
    printf ("good match\n")
  | _  => 
    printf ("bad match\n")
}
good match
executing trace.n:32:m () - def _g = (1, 2)
executing trace.n:33:m () - for (mutable i = 0;i < x;++i) {
  y = x * 3 + y;
  y = 2 * y;
  y *= i
}
executing trace.n:34:m () - y = x * 3 + y
executing trace.n:35:m () - y = 2 * y
executing trace.n:36:m () - y *= i
executing trace.n:34:m () - y = x * 3 + y
executing trace.n:35:m () - y = 2 * y
executing trace.n:36:m () - y *= i
executing trace.n:38:m () - y -= 1
executing trace.n:39:m () - B.hoo ()
executing trace.n:8:hoo () - def x = 6 + 4
executing trace.n:9:hoo () - def y = x * 5
executing trace.n:10:hoo () - print ("$x + $y\n")
10 + 50
executing trace.n:11:hoo () - joo ()
executing trace.n:15:joo () - def u = 8 + 2
executing trace.n:16:joo () - def o = u * 4
executing trace.n:17:joo () - print ("$u + $o\n")
10 + 40
END-OUTPUT
*/
