/*
 * Copyright (c) 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

namespace Nemerle.Compiler
{
  /** A class responsible for assigning new colors to macro contexts. */
  public module MacroColorizer
  {
    public mutable Color : int;
    public mutable UseColor : int;
    public mutable UseContext : GlobalEnv;

    mutable max_macro_color : int;
    mutable colors_stack : list [int * int * GlobalEnv]; // FIXME: use Stack


    this () 
    { 
      Clear ();
    }


    public Clear () : void
    {
      Color = 1;
      UseColor = 1;
      UseContext = null;
      max_macro_color = 1;
      colors_stack = [];
    }
    
                           
    public NewColor () : int
    {
      max_macro_color = max_macro_color + 1;
      max_macro_color
    }


    public InGlobalColor['a] (fn : void -> 'a) : 'a
    {
      try {
        colors_stack = (Color, UseColor, UseContext) :: colors_stack;
        Color = 1;
        UseColor = 1;
        UseContext = GlobalEnv.Core;
        fn ()
      } finally {
        PopColor ();
      }
    }
    
    
    /** Creates new color for execution of macro expansion, stores
        this color as top of the stack, together with [macro_use]
        as context color of currently executed macro.
     */   
    public PushNewColor (use_color : int, use_context : GlobalEnv) : void
    {
      colors_stack = (Color, UseColor, UseContext) :: colors_stack;
      Color = NewColor ();
      UseColor = use_color;
      UseContext = use_context;
    }


    public PushUseSiteColor () : void
    {
      colors_stack = (Color, UseColor, UseContext) :: colors_stack;
      Color = UseColor;
    }
    

    /** Bring color context of previous execution of macro
        (occurs when macro expansion execution finishes).

        Assumes that [PushNewColor] was called before
     */    
    public PopColor () : void
    {
      match (colors_stack) {
        | (col, use_col, use_ctx) :: rest =>
          colors_stack = rest;
          Color = col;
          UseColor = use_col;
          UseContext = use_ctx;
        | [] =>
          Util.ice ("pop from empty stack of macro colors...")
      }
    }
  }

}
