public variant ConstantExpr {
  | Const { v : int; }
  | Ref { name : string; }
  | Binary { op : BinaryOperator; e1 : ConstantExpr; e2 : ConstantExpr; }
  | Not { e : ConstantExpr; }
}

public variant BinaryOperator {
  | Plus
  | Minus
  | Equal
  | Less_than
  | More_than
}

public variant NodeCondition {
  | Sense {
      dir : Direction;
      cond : What;
    }
  | Pickup
  | Move
  | Flip { max : int; }
}

public variant NodeAction {
  | Mark { color : int; }
  | Unmark { color : int; }
  | Drop
  | Turn { is_left : bool; }
}

public variant BooleanFormula {
  | Cond { cond : NodeCondition; }
  | Dummy_true
  | Const { cond : ConstantExpr; }
  | Not { v : BooleanFormula; }
  | And { v1 : BooleanFormula; v2 : BooleanFormula; }
  | Or { v1 : BooleanFormula; v2 : BooleanFormula; }
}

public variant Stmt {
  | If { 
      cond : BooleanFormula;
      then_part : list [Stmt]; 
      else_part : list [Stmt]; 
    }
  | Action { act : NodeAction; }
  | Label { name : string; }
  | Goto { assigns : list [string * BooleanFormula]; target : string; }
  | Vars {
      vars : list [string * int];
      body : list [Stmt];
    }

  public override ToString () : string
  {
    match (this) {
      | Label (n) => "Stmt.Label (" + n + ")"
      | Goto (_, n) => "Stmt.Goto (" + n + ")"
      | _ => this.GetType ().ToString ()
    }
  }
}

public variant What {
  | Friend
  | Foe
  | Friend_with_food
  | Foe_with_food
  | Food
  | Rock
  | Marker { color : int; }
  | Foe_marker
  | Home
  | Foe_home

  public override ToString () : string
  {
    match (this) {
      | Friend => "Friend"
      | Foe => "Foe"
      | Friend_with_food => "FriendWithFood"
      | Foe_with_food => "FoeWithFood"
      | Food => "Food"
      | Rock => "Rock"
      | Marker (c) => "Marker " + c.ToString ()
      | Foe_marker => "FoeMarker"
      | Home => "Home"
      | Foe_home => "FoeHome"
    }
  }
}

public variant Direction {
  | Here
  | Ahead
  | Left
  | Right

  public override ToString () : string
  {
    match (this) {
      | Here => "Here"
      | Ahead => "Ahead"
      | Left => "LeftAhead"
      | Right => "RightAhead"
    }
  }
}
