using System;
using System.IO;
using System.Net;
using System.Text;


namespace POP3Client
{
  public class EraHTTPException : Exception
  {
    public this (text : string)
    {
      base(text)
    }
  }
  

  public class EraHTTP
  {
    protected mutable user     : string;
    protected mutable password : string;

    protected mutable encoding : Encoding; 
    protected mutable request  : HttpWebRequest;
    protected mutable response : HttpWebResponse;
    protected mutable sent     : string;

    protected mutable writer   : StreamWriter;
    protected mutable reader   : StreamReader;
    protected mutable answer   : string;

    protected mutable passwordAddress : string;
    protected mutable smsAddress      : string;
    protected mutable sendAddress     : string;
    protected mutable jsession        : string;
    protected mutable token           : string;


    public this (user : string, password : string)
    {
      this.user     = user;
      this.password = password;
      
      encoding = Encoding.GetEncoding (1250);
    }


    protected CreatePost () : void
    {
      request.Method        = "POST";
      request.ContentType   = "application/x-www-form-urlencoded";
      request.ContentLength = (sent.Length :> long);

      writer = StreamWriter (request.GetRequestStream (), encoding);

      writer.Write (sent);
      writer.Flush ();
    }


    protected CreateGet () : void
    {
      request.Method = "GET";
    }


    protected GetResponse () : string
    {
      mutable result = String.Empty;

      response = (request.GetResponse () :> HttpWebResponse);
      reader   = StreamReader (response.GetResponseStream (), encoding);
      result   = reader.ReadToEnd ();

      writer.Close ();
      reader.Close ();

      result;
    }
    
    
    private Check () : void
    {
      if (answer.IndexOf ("[li]") >= 0)
      {
        mutable begin = answer.IndexOf ("[li]") + 4;
        mutable end   = answer.IndexOf ("</li>");

        throw EraHTTPException (answer.Substring (begin, end - begin)); 
      }
      else {};
    }
    

    protected SendUserName () : void
    {
      sent    = "webId=" + user;
      request = (WebRequest.Create ("http://www.eraomnix.pl/sms/do/logon") :> HttpWebRequest);

      CreatePost ();

      answer = GetResponse ();
      
      Check ();

      try
      {
        mutable splitted = answer.Substring (answer.IndexOf ("<form ")).Split ("\"".ToCharArray (), 15);

        passwordAddress = splitted[5];
        token           = splitted[11] + "=" + splitted[13];
      }
      catch 
      {
        | _e => throw EraHTTPException ("Bad answer from server.");
      }
    }


    protected SendPassword () : void
    {
      request = (WebRequest.Create ("http://www.eraomnix.pl" + passwordAddress) :> HttpWebRequest);
      sent    = token + "&password=" + password;

      CreatePost ();

      answer = GetResponse ();
      
      Check ();

      try
      {
        mutable splitted = answer.Substring (answer.IndexOf ("<form ")).Split ("\"".ToCharArray (), 25);
        smsAddress       = splitted[5];
      }
      catch
      {
        | _e => throw EraHTTPException ("Bad answer from server.");
      }
    }
    
    
    protected Login () : void
    {
      SendUserName ();
      SendPassword ();

    }


    public SendSMS (phone : string, txt : string) : void
    {
      try
      {
        Login ();

        mutable text = txt.Replace (" ", "+");
        
        request = (WebRequest.Create ("http://www.eraomnix.pl" + smsAddress) :> HttpWebRequest);
        sent    = "phoneNumber=" + phone + "&smsContent=" + text;

        CreatePost ();

        answer = GetResponse ();
        
        Check ();     
        
        mutable splitted = answer.Substring (answer.IndexOf ("<a href=\"/sms/do/sendSMS")).Split ("\"".ToCharArray (), 4);
        sendAddress      = splitted[1];

  //      Console.WriteLine (answer);

        request = (WebRequest.Create ("http://www.eraomnix.pl" + sendAddress) :> HttpWebRequest);

        CreateGet ();

        answer = GetResponse ();

//        Console.WriteLine (answer);
      
      }
      catch
      {
        | e => throw EraHTTPException (e.Message);
      }
    }


    public Order () : void
    {
      try
      {
        SendUserName ();
      }
      catch
      {
        | e => throw EraHTTPException (e.Message);
      }
    }
    
    
    public GetLimit () : int
    {
      try
      {
        Login ();

        mutable splitted = answer.Substring (answer.IndexOf ("Limit wiadomo")).Split (" .".ToCharArray (), 10);

        Int32.Parse (splitted[2]);
      }
      catch
      {
        | e => throw EraHTTPException (e.Message);
      }
    }
  }
}
