using System;
using System.Collections;
using System.Collections.Specialized;
using System.Drawing;
using System.IO;
using System.Net.Sockets;

namespace POP3Client
{
  public class POP3EraClient : POP3Client.POP3Client
  {
    private mutable ERAMAIL : string;

    protected mutable retries : int;

    
    public this (server : string, user : string, password : string)
    {
      base (server, user, password);
      
      ERAMAIL = "SMSmajster@sms.era.pl";
      retries = 2;
    }


    public GetEraMessageCount () : int
    {
      GetMessageCount (ERAMAIL);
    }


    public GetTodayEraAttachments () : ListDictionary
    {
      mutable array_ = GetMessages (ERAMAIL);
      mutable result = ListDictionary ();

      foreach (message :> Message in array_)
      {
        if (message.IsToday ()) ignore (result.Add (message.Adreessee, message.GetAttachment (1))) else {};
      };

      result;
    }

    
    public GetTodayEraImages () : ListDictionary
    {
      mutable array_  = GetTodayEraAttachments ();
      mutable result  = ListDictionary ();

      foreach (entry :> DictionaryEntry in array_)
      {
        mutable buffer = (entry.Value :> (array [byte]));
        mutable mem    = MemoryStream (buffer);
        mutable image  = Bitmap (mem);

        ignore (result.Add (entry.Key, image));
      };

      result;
    }


    public new Connect () : void
    {
      mutable retry = 0;

      while (retry < retries)
      {
        try
        {
          (this : POP3Client.POP3Client).Connect ();
          retry = retries;
        }
        catch
        {
          | e is SocketException =>
            retry = retry + 1;
            if (retry == retries) throw SocketException (e.ErrorCode) else {};
          | e  =>
            retry = retry + 1;
            if (retry == retries) throw Exception (e.Message) else {};
        }
      }
    }


    public Retries : int
    {
      get { retries }
      set { if (value > 0) retries = value else {} }
    }

  }
}
