using Nemerle.IO;

namespace NSokoban
{
    public class Sokoban
    {
	public static Main (args : array[string]) : void
	{
	    if(args.Length != 3)
		System.Console.WriteLine("usage: sokoban LEVELS_FILE LEVEL_NUMBER METHOD");
	    else
	    {
		//try
		//{
		    def Maps = MapCollection (args[0]);
		    def x = Maps.Nth(System.Int32.Parse(args[1])-1);
		    SMap.Visited = Nemerle.Collections.Hashtable ();
		    def (f,r) = 
		    match(args[2])
		    {
			| "IDFS" => TreeSearch.IDFS(x);
			| "BlindIDFS" => TreeSearch.BlindIDFS(x);
			| "BFS" => TreeSearch.BFS(x);
			| "A*" => TreeSearch.A_Star(x);
			| "IDA*" => TreeSearch.IDA(x);
			| "RBFS" => TreeSearch.RBFS(x);
			| "SA" => LocalSearch.SimulatedAnnealing(x,0.95);
			| m => throw System.Exception("Unknown method: " + m);
		    }
		 
		    if(f)  
			System.Console.WriteLine(Option.UnSome(r).ToString ());
		    else
			System.Console.WriteLine("Solution was not found");		    	    
		//}
		/*catch
		{
		    e : System.Exception => System.Console.WriteLine(e.Message);
		}*/
	    }
	}
    }
}
