#ifndef FILE_L2HOFESPACE
#define FILE_L2HOFESPACE

/*********************************************************************/
/* File:   l2hofespace.hpp                                           */
/* Author: Start                                                     */
/* Date:   24. Feb. 2003                                             */
/*********************************************************************/
  
/**
   High Order Finite Element Space for L2 (element by element)
*/


class L2HighOrderFESpace : public FESpace
{
private:
  
  // Level
  int level;

  // Number of Elements
  int nel;

  ARRAY<int> first_element_dof;
  int ndof;

public:

  L2HighOrderFESpace (const MeshAccess & ama, const Flags & flags);
  ///
  virtual ~L2HighOrderFESpace ();

  static FESpace * Create (const MeshAccess & ma, const Flags & flags);

  virtual string GetClassName () const
  {
    return "L2HighOrderFESpace";
  }

  ///
  virtual void Update();
  ///
  virtual int GetNDof () const;
  ///
  virtual const FiniteElement & GetFE (int elnr, LocalHeap & lh) const;
  ///
  virtual const FiniteElement & GetSFE (int elnr, LocalHeap & lh) const;
  ///
  virtual void GetDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetSDofNrs (int selnr, ARRAY<int> & dnums) const;
  
  virtual Table<int> * CreateSmoothingBlocks ( int type = 0) const;
};






class L2SurfaceHighOrderFESpace : public FESpace
{
private:
  
  // Level
  int level;

  // Number of Elements
  int nel;

  ARRAY<int> first_element_dof;
  int ndof;

public:

  L2SurfaceHighOrderFESpace (const MeshAccess & ama, const Flags & flags);
  ///
  virtual ~L2SurfaceHighOrderFESpace ();

  static FESpace * Create (const MeshAccess & ma, const Flags & flags);

  virtual string GetClassName () const
  {
    return "L2SurfaceHighOrderFESpace";
  }

  ///
  virtual void Update();
  ///
  virtual int GetNDof () const;
  ///
  virtual const FiniteElement & GetFE (int elnr, LocalHeap & lh) const;
  ///
  virtual const FiniteElement & GetSFE (int elnr, LocalHeap & lh) const;
  ///
  virtual void GetDofNrs (int elnr, ARRAY<int> & dnums) const;
  ///
  virtual void GetSDofNrs (int selnr, ARRAY<int> & dnums) const;
  
  virtual Table<int> * CreateSmoothingBlocks ( int type = 0) const;
};

#endif

