/*********************************************************************/
/* File:   vvector.cpp                                               */
/* Author: Joachim Schoeberl                                         */
/* Date:   25. Aug. 2002                                             */
/*********************************************************************/

/* 
   Implementation of VVector
*/

#include <la.hpp>
namespace ngla
{
  using namespace ngla;

  // #include "tbasevector_impl.hpp"


  template <typename T>
  VFlatVector<T> :: VFlatVector () throw()
  { 
    this->entrysize = sizeof(T) / sizeof(double);
  }

  template <typename T>
  VFlatVector<T> :: VFlatVector (int as, T * adata) throw()
    : data(adata)
  { 
    this->size = as;
    this->entrysize = sizeof(T) / sizeof(double);
  }

  template <typename T>
  VFlatVector<T> :: ~VFlatVector() throw()
  { ; }

  /*  
  template <typename T>
  FlatVector<T> VFlatVector<T> :: FV () const throw()
  {
    return FlatVector<T> (size, data);
  }

  template <typename T>
  FlatVector<T> VFlatVector<T> :: FV () throw()
  {
    return FlatVector<T> (size, data);
  }
  */






  template <typename T>
  VVector<T> :: VVector (int as) 
    : data(as)
  { 
    this->size = as;
    this->entrysize = sizeof(T) / sizeof(double);

    // data = new T[s];
    data.SetName ("VVector");
    // mem_total_alloc_vector += as * sizeof(T);
  }

  template <typename T>
  VVector<T> :: ~VVector() throw()
  { 
    // delete data; 
  }
  

  /*
  template <typename T>
  FlatVector<T> VVector<T> :: FV () const throw()
  {
    return FlatVector<T> (size, const_cast<T*> (&data[0]));
  }

  template <typename T>
  FlatVector<T> VVector<T> :: FV () throw()
  {
    return FlatVector<T> (size, data);
  }
  */

  template <typename T>
  void VVector<T> :: SetSize(int as)
  {
    if (this->size == as) return;
    this->size = as;
    data.Alloc (this->size);
  }



  template class T_BaseVector<double>;
  template class T_BaseVector<Complex>;
  template class T_BaseVector<Vec<1,double> >;
  template class T_BaseVector<Vec<1,Complex> >;
  template class T_BaseVector<Vec<2,double> >;
  template class T_BaseVector<Vec<2,Complex> >;
  template class T_BaseVector<Vec<3,double> >;
  template class T_BaseVector<Vec<3,Complex> >;
  template class T_BaseVector<Vec<4,double> >;
  template class T_BaseVector<Vec<4,Complex> >;

  template class T_BaseVector<Vec<5,double> >;
  template class T_BaseVector<Vec<5,Complex> >;
  template class T_BaseVector<Vec<6,double> >;
  template class T_BaseVector<Vec<6,Complex> >;
  template class T_BaseVector<Vec<7,double> >;
  template class T_BaseVector<Vec<7,Complex> >;
  template class T_BaseVector<Vec<8,double> >;
  template class T_BaseVector<Vec<8,Complex> >;
  template class T_BaseVector<Vec<9,double> >;
  template class T_BaseVector<Vec<9,Complex> >;

  template class T_BaseVector<Vec<12,double> >;
  template class T_BaseVector<Vec<12,Complex> >;
  template class T_BaseVector<Vec<18,double> >;
  template class T_BaseVector<Vec<18,Complex> >;
  template class T_BaseVector<Vec<24,double> >;
  template class T_BaseVector<Vec<24,Complex> >;

  template class VFlatVector<double>;
  template class VFlatVector<Complex>;
  template class VFlatVector<Vec<1,double> >;
  template class VFlatVector<Vec<1,Complex> >;
  template class VFlatVector<Vec<2,double> >;
  template class VFlatVector<Vec<2,Complex> >;
  template class VFlatVector<Vec<3,double> >;
  template class VFlatVector<Vec<3,Complex> >;
  template class VFlatVector<Vec<4,double> >;
  template class VFlatVector<Vec<4,Complex> >;

  template class VFlatVector<Vec<5,double> >;
  template class VFlatVector<Vec<5,Complex> >;
  template class VFlatVector<Vec<6,double> >;
  template class VFlatVector<Vec<6,Complex> >;
  template class VFlatVector<Vec<7,double> >;
  template class VFlatVector<Vec<7,Complex> >;
  template class VFlatVector<Vec<8,double> >;
  template class VFlatVector<Vec<8,Complex> >;
  template class VFlatVector<Vec<9,double> >;
  template class VFlatVector<Vec<9,Complex> >;

  template class VFlatVector<Vec<12,double> >;
  template class VFlatVector<Vec<12,Complex> >;
  template class VFlatVector<Vec<18,double> >;
  template class VFlatVector<Vec<18,Complex> >;
  template class VFlatVector<Vec<24,double> >;
  template class VFlatVector<Vec<24,Complex> >;


  template class VVector<double>;
  template class VVector<Complex>;
  template class VVector<Vec<1,double> >;
  template class VVector<Vec<1,Complex> >;
  template class VVector<Vec<2,double> >;
  template class VVector<Vec<2,Complex> >;
  template class VVector<Vec<3,double> >;
  template class VVector<Vec<3,Complex> >;
  template class VVector<Vec<4,double> >;
  template class VVector<Vec<4,Complex> >;

  template class VVector<Vec<5,double> >;
  template class VVector<Vec<5,Complex> >;
  template class VVector<Vec<6,double> >;
  template class VVector<Vec<6,Complex> >;
  template class VVector<Vec<7,double> >;
  template class VVector<Vec<7,Complex> >;
  template class VVector<Vec<8,double> >;
  template class VVector<Vec<8,Complex> >;
  template class VVector<Vec<9,double> >;
  template class VVector<Vec<9,Complex> >;

  template class VVector<Vec<12,double> >;
  template class VVector<Vec<12,Complex> >;
  template class VVector<Vec<18,double> >;
  template class VVector<Vec<18,Complex> >;
  template class VVector<Vec<24,double> >;
  template class VVector<Vec<24,Complex> >;







  /*
  template class T_BaseVector<Mat<1,1,double> >;
  template class T_BaseVector<Mat<1,1,Complex> >;
  template class T_BaseVector<Mat<2,2,double> >;
  template class T_BaseVector<Mat<2,2,Complex> >;
  template class T_BaseVector<Mat<3,3,double> >;
  template class T_BaseVector<Mat<3,3,Complex> >;
  template class T_BaseVector<Mat<4,4,double> >;
  template class T_BaseVector<Mat<4,4,Complex> >;

  template class T_BaseVector<Mat<5,5,double> >;
  template class T_BaseVector<Mat<5,5,Complex> >;
  template class T_BaseVector<Mat<6,6,double> >;
  template class T_BaseVector<Mat<6,6,Complex> >;
  template class T_BaseVector<Mat<7,7,double> >;
  template class T_BaseVector<Mat<7,7,Complex> >;
  template class T_BaseVector<Mat<8,8,double> >;
  template class T_BaseVector<Mat<8,8,Complex> >;


  template class VFlatVector<Mat<1,1,double> >;
  template class VFlatVector<Mat<1,1,Complex> >;
  template class VFlatVector<Mat<2,2,double> >;
  template class VFlatVector<Mat<2,2,Complex> >;
  template class VFlatVector<Mat<3,3,double> >;
  template class VFlatVector<Mat<3,3,Complex> >;
  template class VFlatVector<Mat<4,4,double> >;
  template class VFlatVector<Mat<4,4,Complex> >;

  template class VFlatVector<Mat<5,5,double> >;
  template class VFlatVector<Mat<5,5,Complex> >;
  template class VFlatVector<Mat<6,6,double> >;
  template class VFlatVector<Mat<6,6,Complex> >;
  template class VFlatVector<Mat<7,7,double> >;
  template class VFlatVector<Mat<7,7,Complex> >;
  template class VFlatVector<Mat<8,8,double> >;
  template class VFlatVector<Mat<8,8,Complex> >;



  template class VVector<Mat<1,1,double> >;
  template class VVector<Mat<1,1,Complex> >;
  template class VVector<Mat<2,2,double> >;
  template class VVector<Mat<2,2,Complex> >;
  template class VVector<Mat<3,3,double> >;
  template class VVector<Mat<3,3,Complex> >;
  template class VVector<Mat<4,4,double> >;
  template class VVector<Mat<4,4,Complex> >;

  template class VVector<Mat<5,5,double> >;
  template class VVector<Mat<5,5,Complex> >;
  template class VVector<Mat<6,6,double> >;
  template class VVector<Mat<6,6,Complex> >;
  template class VVector<Mat<7,7,double> >;
  template class VVector<Mat<7,7,Complex> >;
  template class VVector<Mat<8,8,double> >;
  template class VVector<Mat<8,8,Complex> >;
  */
}
