geometry = ngsolve/pde_tutorial/coil.geo
mesh = ngsolve/pde_tutorial/coil.vol

define constant geometryorder = 2
define constant secondorder = 0

define coefficient nu
1, 1, 

define coefficient sigma
1e-6, 1e-6,

define coefficient cs1
( x2 ), 0,
define coefficient cs2
( -x1 ), 0,
define coefficient cs3
0, 0, 0

define coefficient penalty
1e6, 0, 0, 0, 0, 0

define coefficient one 
1,1,1,1,1,1,1,1,1

define fespace v -hcurlho -order=4 -nograds -noeliminate_internal 
define fespace vb -l2ho -order=2 -dim=3 


define gridfunction u -fespace=v -novisual
# define gridfunction b -fespace=vb

define linearform f -fespace=v
sourceedge cs1 cs2 cs3 -definedon=1



# define bilinearform a -fespace=v 
define bilinearform a -fespace=v -symmetric -noeliminate_internal -linearform=f
curlcurledge nu 
massedge sigma -order=2
#robinedge penalty

define bilinearform a2 -fespace=v -symmetric -nonassemble
curlcurledge nu 
massedge sigma -order=2
#robinedge penalty



define bilinearform acurl -fespace=v -symmetric -nonassemble
curlcurledge nu 



define preconditioner c -type=multigrid -bilinearform=a -cylce=1 -smoother=block -coarsetype=direct -coarsesmoothingsteps=5 -notest
#define preconditioner c -type=amg -bilinearform=a -hcurl -coefe=sigma -coeff=nu -notiming -notest
# define preconditioner c -type=direct -bilinearform=a


numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=50 -prec=1.e-8

numproc drawflux np5 -bilinearform=acurl -solution=u  -label=flux
# numproc calcflux np6 -bilinearform=acurl -solution=u -flux=b

# numproc evaluate npeval -linearform=f -gridfunction=u


# static cond, p=4, tot=20.4