/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qapplication.h>
#include <qstring.h>

#include "netgodialog.h"
#include "setup.h"
#include "settings.h"

int main(int argc, char **argv)
{
	// Create a QApplication-object.
	QApplication app(argc, argv);
			
	// Check if we need to run the setup.
	if (!Settings::fetchSettings()) {
		Setup *netGoSetup = new Setup();
		netGoSetup->exec();
	}
	
	// Check if '--hide' was specified.
	if ((app.argc() == 2) && (QString::QString(app.argv()[1]) == "--hide")) {
		netGoDialog *netGo = new netGoDialog(0, "netGo");
		app.setMainWidget(netGo);
	}	
	// Check if a profile was specified from the commandline.
	else if (app.argc() == 2)
		// Create an netGoDialog object (without GUI).
		netGoDialog *cmdline = new netGoDialog(QString::QString(app.argv()[1]));
	else {
		// Create a netGoDialog object (with GUI).
		netGoDialog *netGo = new netGoDialog(0, "netGo");
		app.setMainWidget(netGo);
		netGo->show();
	}
		
	return app.exec();
}
