/* Copyright (C) 2004 Per Johansson
	
	This file is part of netGo.

    netGo is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    netGo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with netGo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <qstring.h>
#include <qstringlist.h>
#include <qsettings.h>
#include <qdir.h>
#include <qmessagebox.h>

#include "settings.h"

// Allocate memory for the variables and make them global.
QString Settings::IFCONFIG_PATH = "";
QString Settings::ROUTE_PATH = "";
QString Settings::IWCONFIG_PATH = "";
QString Settings::DHCP_CLIENT_PATH = "";
QString Settings::DHCP_CLIENT = "";

QString Settings::NOTIFY_TRAY = "";

// Default constructor.
Settings::Settings()
{
}

// Function that checks if there are any user settings
// specified in settings.txt. Returns true if there's settings.
bool Settings::fetchSettings()
{
	QSettings paths;
	paths.insertSearchPath(QSettings::Unix, QDir::homeDirPath() + "/.qt");
	
	// If any of the  paths aren't specified - return false.	
	QString ifconfig = paths.readEntry("/netgo/paths/ifconfig");
	QString route = paths.readEntry("/netgo/paths/route");
	QString iwconfig = paths.readEntry("/netgo/paths/iwconfig");
	QString dhcp_client = paths.readEntry("/netgo/paths/dhcp client");
	if (ifconfig.isEmpty() || route.isEmpty() || iwconfig.isEmpty() || dhcp_client.isEmpty() )
		return false;
	
	// Import the paths and save them in static variables. 
	paths.beginGroup("/netgo/paths");
		IFCONFIG_PATH = paths.readEntry("ifconfig");
		ROUTE_PATH = paths.readEntry("route");
		IWCONFIG_PATH = paths.readEntry("iwconfig");
		DHCP_CLIENT_PATH = paths.readEntry("dhcp client");
		int pos = DHCP_CLIENT_PATH.findRev("/");
		DHCP_CLIENT = DHCP_CLIENT_PATH.mid(pos+1, 100);
	paths.endGroup();

	// Import the notify tray setting.
	NOTIFY_TRAY = paths.readEntry("/netgo/misc/notify tray", "yes");
	
	// If the function hasn't failed, return true.
	return true;
}

// Debug function that dumps all the settings.
void Settings::dumpSettings()
{
	qWarning("ifconfig path: " + IFCONFIG_PATH + "\n"
			"route path: " + ROUTE_PATH + "\n"
			"iwconfig path: " + IWCONFIG_PATH + "\n"
			"dhcp-client path: " + DHCP_CLIENT_PATH + "\n"
			"dhcp-client: " + DHCP_CLIENT + "\n"
			"notify tray: " + NOTIFY_TRAY);
}
