#ifndef NOMAD_ID3_H
#define NOMAD_ID3_H

#include <glib-object.h>

#define NOMAD_TYPE_ID3  (nomad_id3_get_type())
#define NOMAD_ID3(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), \
                              NOMAD_TYPE_ID3, \
                              NomadID3 ) )
#define NOMAD_ID3_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
				      NOMAD_TYPE_ID3, \
                                      NomadID3Class ) )
#define NOMAD_IS_ID3(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), \
                                 NOMAD_TYPE_ID3 ) )

#define ID3V1_TITLE_SIZE 30
#define ID3V1_ARTIST_SIZE 30
#define ID3V1_ALBUM_SIZE 30
#define ID3V1_YEAR_SIZE 4
#define ID3V1_COMMENT_SIZE 30
#define ID3V1_DOT_1_COMMENT_SIZE 28
typedef struct {
	gchar title[ ID3V1_TITLE_SIZE ];
	gchar artist[ ID3V1_ARTIST_SIZE ];
	gchar album[ ID3V1_ALBUM_SIZE ];
	gchar year[ ID3V1_YEAR_SIZE ];
	union {
		gchar comment[ ID3V1_COMMENT_SIZE ];
		struct {
			gchar comment1dot_1[ ID3V1_DOT_1_COMMENT_SIZE ];
			gchar empty;
			gchar track;
		} __attribute((packed)) V1dot1;
	} comment;
	gchar genre;
} __attribute((packed)) ID3V1;


typedef struct {
	gchar id[ 3 ];
	gint16 version;
	gchar  flags;
	gint32  size;
} __attribute((packed)) ID3V2Header;
static const int ID3V2HeaderSize = sizeof( ID3V2Header );

typedef struct {
	gchar id[ 4 ];
	gint32 size;
	gshort flags;
} __attribute((packed)) ID3V2Frame;

typedef struct {
	gchar encoding;
	gchar string[];
} __attribute((packed)) ID3V2TextFrame;

typedef struct {
	ID3V2Header header;
	gboolean hasExtended;
	void *frames;
} ID3V2;



typedef struct {
	GObjectClass parent_spot;

} NomadID3Class;


typedef struct NomadID3Details NomadID3Details;

typedef struct  {
	GObject parent_object;

	NomadID3Details *details;
} NomadID3;


GType  nomad_id3_get_type( void );
NomadID3 *nomad_id3_new( const gchar *uri );

/* not actually in an ID3 tag, but as we know the filesize
   through checking for existance of the file we may as
   well get it from here */
gchar *nomad_id3_get_filesize( NomadID3 *id3 );

/* V2 tags may contain the length, V1 can't so this
   func will calculate the length if it isn't stored in a tag */
gchar *nomad_id3_get_length( NomadID3 *id3 );

gchar *nomad_id3_get_title( NomadID3 *id3 );
gchar *nomad_id3_get_artist( NomadID3 *id3 );
gchar *nomad_id3_get_album( NomadID3 *id3 );
gchar *nomad_id3_get_year( NomadID3 *id3 );
gchar *nomad_id3_get_comment( NomadID3 *id3 );
gchar *nomad_id3_get_track( NomadID3 *id3 );
gchar *nomad_id3_get_genre( NomadID3 *id3 );

gboolean nomad_id3_tag_v1dot1( const gchar *uri,
			      const gchar *title,
			      const gchar *artist,
			      const gchar *album,
			      const gchar *year,
			      const gchar *track,
			      const gchar *genre );
gboolean nomad_id3_tag_v1dot1_with_handle( gpointer handle,
		const gchar *title, const gchar *artist,
		const gchar *album, const gchar *year,
		const gchar *track, const gchar *genre );

gboolean nomad_id3_tag_v2( const gchar *uri,
			  const gchar *title,
			  const gchar *artist,
			  const gchar *album,
			  const gchar *year,
			  const gchar *track,
			  const gchar *genre,
			  const gchar *length );

gboolean nomad_id3_tag_v2_with_handle( gpointer handle,
		const gchar *title, const gchar *artist,
		const gchar *album, const gchar *year,
		const gchar *track, const gchar *genre,
		const gchar *length );

void nomad_id3_strip_v1dot1( const gchar *uri );
void nomad_id3_strip_v2( const gchar *uri );

gint nomad_id3_get_length_from_header( ID3V2Header *header );

#endif
