/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddPublicationEntity.cpp: implementation of the DlgAddPublicationEntity class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddPublicationEntity.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddPublicationEntity, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddPublicationEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddPublicationEntity::OnCancel)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_ENTITY, DlgAddPublicationEntity::OnServerKeyEntity)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_ENTITY, DlgAddPublicationEntity::OnEngineKeyEntity)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_OCSP, DlgAddPublicationEntity::OnServerKeyOCSP)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_OCSP, DlgAddPublicationEntity::OnEngineKeyOCSP)
END_EVENT_TABLE()


DlgAddPublicationEntity::DlgAddPublicationEntity(wxWindow * wParent, PkiClient * ClientPki):DlgAddEntity(wParent, _("Add Publication Entity"), ClientPki)
{
	DlgAddPublicationEntity_SetWindow(this);


	LoadKeyLen((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY));
	LoadKeyLen((wxComboBox *)FindWindow(IDC_LIST_LEN_OCSP));


	wxCommandEvent event2;
	OnServerKeyEntity(event2);
	OnServerKeyOCSP(event2);
	CenterOnScreen();
	ShowModal();
}

DlgAddPublicationEntity::~DlgAddPublicationEntity()
{
}

void DlgAddPublicationEntity::OnOk(wxCommandEvent& event)
{
	int nItem;
	wxString m_KeyId;
	int RsaLen;	
	PubCreationReq pub_create;
	wxString m_EntityName;
	wxString m_EntityMail;


	m_EntityName = ((wxTextCtrl *)FindWindow(IDC_ENTITY_NAME))->GetValue();
	if(!m_EntityName.Len())
	{
		return;
	}
	m_EntityMail = ((wxTextCtrl *)FindWindow(IDC_EMAIL))->GetValue();
	if(!m_EntityMail.Len())
	{
		return;
	}

	// Entity Cert KEY
	if( ((wxRadioButton *)FindWindow(IDC_KEY_ENGINE_ENTITY))->GetValue() )
	{
		if( !((wxTextCtrl *)FindWindow(IDC_KEY_ID_ENTITY))->GetValue().Len() )
		{
			return;
		}
		m_KeyId = ENGINE_HEAD;
		m_KeyId += ((wxTextCtrl *)FindWindow(IDC_KEY_ID_ENTITY))->GetValue();
		
		if(pub_create.get_entityKey().set_type(GEN_PRIVATE_KEY_TYPE_ENGINE))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		pub_create.get_entityKey().set_keyid(m_KeyId.GetData());
	}
	else
	{
		nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY))->GetSelection();
		RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY))->GetClientData(nItem);
		
		if(!pub_create.get_entityKey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		pub_create.get_entityKey().set_keylen(RsaLen);
	}

	// OCSP Cert KEY
	if( ((wxRadioButton *)FindWindow(IDC_KEY_ENGINE_OCSP))->GetValue() )
	{
		if( !((wxTextCtrl *)FindWindow(IDC_KEY_ID_OCSP))->GetValue().Len() )
		{
			return;
		}

		m_KeyId = ENGINE_HEAD;
		m_KeyId += ((wxTextCtrl *)FindWindow(IDC_KEY_ID_OCSP))->GetValue();
		
		if(pub_create.get_ocspKey().set_type(GEN_PRIVATE_KEY_TYPE_ENGINE))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		pub_create.get_ocspKey().set_keyid(m_KeyId.GetData());
	}
	else
	{
		nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN_OCSP))->GetSelection();
		RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN_OCSP))->GetClientData(nItem);
		
		if(!pub_create.get_ocspKey().set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		pub_create.get_ocspKey().set_keylen(RsaLen);
	}
	
	if(!AddEntity(m_EntityName.GetData(), m_EntityMail.GetData(), ENTITY_TYPE_PUBLICATION, GenPrivateKey::EmptyInstance, pub_create, NULL, 0))
		return;

	m_IsOK = true;
	Close(TRUE);
}

void DlgAddPublicationEntity::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


void DlgAddPublicationEntity::OnServerKeyEntity(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_ENTITY, IDC_KEY_ID_ENTITY, IDC_LBL_KEYLEN_ENTITY, IDC_LIST_LEN_ENTITY);
}

void DlgAddPublicationEntity::OnEngineKeyEntity(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_ENTITY, IDC_KEY_ID_ENTITY, IDC_LBL_KEYLEN_ENTITY, IDC_LIST_LEN_ENTITY);
}

void DlgAddPublicationEntity::OnServerKeyOCSP(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_OCSP, IDC_KEY_ID_OCSP, IDC_LBL_KEYLEN_OCSP, IDC_LIST_LEN_OCSP);
}

void DlgAddPublicationEntity::OnEngineKeyOCSP(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_OCSP, IDC_KEY_ID_OCSP, IDC_LBL_KEYLEN_OCSP, IDC_LIST_LEN_OCSP);
}
