/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgGetLink.cpp: implementation of the DlgGetLink class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgGetLink.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgGetLink, wxDialog)
    EVT_BUTTON(IDC_OK, DlgGetLink::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgGetLink::OnCancel)
END_EVENT_TABLE()

DlgGetLink::DlgGetLink(wxWindow * wParent, const mVector<EntityLinks>& links, const mVector<size_t> & List):wxDialog(wParent, (wxWindowID)-1, _("Select link"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxCAPTION | wxRESIZE_BORDER)
{
	m_IsOK = false;
	int LogoPki;
	int LogoCa;
	int LogoRa;
	int LogoRep;
	int LogoPub;
	int LogoKey;
	int LogoEE;
	int LogoUnknown;
	int LogoId;
	size_t i;
	const char * EntityType;

	DlgGetLink_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(ID_LISTCTRL));
	m_imageListSmall = new wxImageList(16, 16, TRUE);
	wxIcon ico;

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_PKI_SMALL));
	LogoPki = m_imageListSmall->Add( ico );
	
	ico.CopyFromBitmap(Entities_GetBitmap(IDB_CA_SMALL));
	LogoCa = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_RA_SMALL));
	LogoRa = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_REP_SMALL));
	LogoRep = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_PUB_SMALL));
	LogoPub = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_KEY_SMALL));
	LogoKey = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_EE_SMALL));
	LogoEE = m_imageListSmall->Add( ico );

	ico.CopyFromBitmap(Entities_GetBitmap(IDB_UNKNOWN_SMALL));
	LogoUnknown = m_imageListSmall->Add( ico );

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Name"), wxLIST_ALIGN_DEFAULT, 150);
	m_listCtrl->InsertColumn(1, _("Type"), wxLIST_ALIGN_DEFAULT, 100);


	for(i=0; i<List.size(); i++)
	{
		switch(links[List[i]].get_src().get_type())
		{
			case ENTITY_TYPE_REPOSITORY:
				LogoId = LogoRep;
				EntityType = _("Repository");
				break;
			case ENTITY_TYPE_PKI:
				LogoId = LogoPki;
				EntityType = _("PKI");
				break;
			case ENTITY_TYPE_CA:
				LogoId = LogoCa;
				EntityType = _("CA");
				break;
			case ENTITY_TYPE_RA:
				LogoId = LogoRa;
				EntityType = _("RA");
				break;
			case ENTITY_TYPE_PUBLICATION:
				LogoId = LogoPub;
				EntityType = _("Publication");
				break;
			case ENTITY_TYPE_KEY_STORE:
				LogoId = LogoKey;
				EntityType = _("Key Store");
				break;
			case ENTITY_TYPE_EE:
				LogoId = LogoEE;
				EntityType = _("EE");
				break;
			default:
				LogoId = LogoUnknown;
				EntityType = _("Unknown");
				break;
		}
		m_listCtrl->InsertItem(i, links[List[i]].get_src().get_name().c_str(), LogoId);
		m_listCtrl->SetItem(i, 1, EntityType);
		m_listCtrl->SetItemData(i, (long)List[i]);
	}


	CenterOnScreen();
	ShowModal();
}

DlgGetLink::~DlgGetLink()
{
	m_listCtrl->ClearAll();
	if(m_imageListSmall) delete m_imageListSmall;
}

void DlgGetLink::OnOk(wxCommandEvent& event)
{
	Selection.clear();
	int SelectedItem = -1;
	while( (SelectedItem = m_listCtrl->GetNextItem(SelectedItem, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED)) != -1 )
	{
		Selection.push_back((size_t)m_listCtrl->GetItemData(SelectedItem));
	}
	if(!Selection.size()) return;

	m_IsOK = true;
	Close(TRUE);
}

void DlgGetLink::OnCancel(wxCommandEvent& event)
{
	Selection.clear();
	m_IsOK = false;
	Close(TRUE);
}


bool DlgGetLink::IsOK()
{
	return m_IsOK;
}

const vector<size_t> & DlgGetLink::GetSelection()
{
	return Selection;
}
