/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgProgress.cpp: implementation of the DlgProgress class.
//
//////////////////////////////////////////////////////////////////////
#include "DlgProgress.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgProgress, wxDialog)
	EVT_BUTTON(IDC_CANCEL, DlgProgress::OnCancel)
    EVT_CLOSE(DlgProgress::OnClose)
END_EVENT_TABLE()


DlgProgress::DlgProgress(wxWindow * wParent):wxDialog(wParent, (wxWindowID)-1, _("Please wait..."), wxDefaultPosition, wxDefaultSize, wxCAPTION)
{
	m_IsCanceled = false;
	m_wParent = wParent;
	DlgProgress_SetWindow(this);
	m_Progress = (wxGauge *)FindWindow(IDC_PROGRESS);
	CenterOnScreen();
}

DlgProgress::~DlgProgress()
{
	wHide();
}

void DlgProgress::wShow()
{
	Show(TRUE);
	Enable(TRUE);
	if(m_wParent)
		m_wParent->Enable(FALSE);
}

void DlgProgress::wHide()
{
	Hide();
	if(m_wParent)
		m_wParent->Enable(TRUE);
}

void DlgProgress::OnClose(wxCloseEvent &event)
{
	event.SetCanVeto(true);
	event.Veto(true);
}

void DlgProgress::SetValue(int Pos)
{
	m_Progress->SetValue(Pos);
}
void DlgProgress::SetMax(int Max)
{
	m_Progress->SetRange(Max);
}

void DlgProgress::SetTitle(const char *Title)
{
	wxString tt;
	tt.sprintf("%s - %s", _("Please wait..."), Title);
	wxDialog::SetTitle(tt);
}

void DlgProgress::OnCancel(wxCommandEvent &event)
{
	m_IsCanceled = true;
	((wxButton*)FindWindow(IDC_CANCEL))->Enable(FALSE);
}

bool DlgProgress::IsCanceled()
{
	return m_IsCanceled;
}
