/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef XMLIMPORT_H
#define XMLIMPORT_H

#include <ASN1/Asn1Req.h>
#include <libxml/parserInternals.h>
#include <libxml/parser.h>

#include <vector>
using namespace std;

class XmlRequest
{
public:
	XmlRequest(const EntityConf & cEntityConf);
	~XmlRequest();
	bool Load(xmlNodePtr RequestNode);
	bool Dump(xmlNodePtr ParentNode) const;
	NewpkiRequestCert & get_Request();
	void set_Request(const NewpkiRequestCert & request);
	const mString & get_CSP() const;
	long get_KeyLen() const;
	const mString & get_Error() const;
	const mString & get_CaName() const;
	void set_CaName(const mString & caname);
	void set_CSP(const mString & csp);
	void set_KeyLen(long keylen);
	bool IsError() const;
	bool IsImported() const;
	void set_Imported(bool imported);
	void set_Error(const mString & error);
private:
	bool PrivLoad(xmlNodePtr RequestNode);
	bool m_error;
	NewpkiRequestCert m_request;
	mString m_csp;
	long m_keylen;
	mString m_strerror;
	mString m_caname;
	const EntityConf & m_EntityConf;
	bool m_isImported;
};


class XmlProfile
{
public:
	XmlProfile(const EntityConf & cEntityConf);
	~XmlProfile();
	void Clear();
	bool Load(xmlNodePtr ProfileNode);
	bool Dump(FILE * fp, xmlDocPtr xDoc) const;
	const char * GetName();
	bool IsError() const;
	bool IsImported() const;
	void set_Imported(bool imported);
	unsigned long get_Id() const;
	void set_Id(unsigned long id);
	const mString & get_Error() const;
	vector<XmlRequest*> & get_Requests();
	const NewpkiProfile & get_Profile() const;
	void set_Error(const mString & error);
	void set_ItemId(int id);
	int get_ItemId();
private:
	bool PrivLoad(xmlNodePtr ProfileNode);
	bool LoadDn(xmlNodePtr DnNode);
	NewpkiProfile m_profile;
	vector<XmlRequest*> m_requests;
	char * dn_name;
	bool m_error;
	mString m_strerror;
	const EntityConf & m_EntityConf;
	bool m_isImported;
	unsigned long m_Id;
	int m_ItemId;
	mString m_ownerGroup;
};


#endif
