/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// CriticalSection.h: interface for the CriticalSection class.
//
//////////////////////////////////////////////////////////////////////

#ifndef CRITICALSECTION_H
#define CRITICALSECTION_H


#ifdef _WIN32
	#include <windows.h>
#else
	#include <pthread.h>
#endif
#ifdef _DEBUG
	typedef struct st_CSFileLine
	{
		const char * file;
		int line;
	}CSFileLine;
#endif

/*!
  This class represents a critical section
*/
class CriticalSection
{
public:
	/*! \brief This is the constructor.
	 */
	CriticalSection();

	/*! \brief This is the destructor.
	 */
	virtual ~CriticalSection();

#ifdef _DEBUG
	void DoEnterCS(const char * file, int line) const;
	#define EnterCS() DoEnterCS(__FILE__, __LINE__)
#else
	/*! \brief This function is called to enter the critical section.
	 */
	void EnterCS() const;
#endif

	/*! \brief This function is called to leave the critical section.
	 */
	void LeaveCS() const;
private:
	#ifdef WIN32
		HANDLE hMutex;
	#else
		pthread_mutex_t lpCriticalSection;
		pthread_mutexattr_t recmutex;
	#endif
#ifdef _DEBUG
	int m_stIndex;
	CSFileLine m_stLockers[300];
#endif
};

#endif // CRITICALSECTION_H

