/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PEM_DER.cpp: implementation of the PEM_DER class.
//
//////////////////////////////////////////////////////////////////////

#include "PEM_DER.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PEM_DER::PEM_DER()
{
}

PEM_DER::~PEM_DER()
{

}

bool PEM_DER::Der2Pem(const char *indatas, int indataslen, char **outdatas, int *outdataslen)
{
	int outl;
	unsigned char *buf;
	EVP_ENCODE_CTX ctx;
	

	//We test the parameters
	if(!indatas || !indataslen || !outdatas || !outdataslen)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_PARAM);
		return false;
	}
	
	buf=(unsigned char *)malloc(indataslen*2 + 1);
	if(!buf)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	
	*outdataslen = 0;

	EVP_EncodeInit(&ctx);
	EVP_EncodeUpdate(&ctx, (unsigned char *)buf, outdataslen, (unsigned char *)indatas, indataslen);
	EVP_EncodeFinal(&ctx, (unsigned char *)buf + *outdataslen, &outl);

	(*outdatas)=(char *)buf;
	*outdataslen += outl;
	buf[(*outdataslen)] = 0;
	return true;
}

bool PEM_DER::Pem2Der(const char *indatas, int indataslen, char **outdatas, int *outdataslen)
{
	int i,outl;
	unsigned char *buf;
	EVP_ENCODE_CTX ctx;
	

	//We test the parameters
	if(!indatas || !indataslen || !outdatas || !outdataslen)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_PARAM);
		return false;
	}
	

	buf=(unsigned char *)malloc(indataslen);
	if(!buf)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_MALLOC);
		return false;
	}
	
	EVP_DecodeInit(&ctx);
	if(EVP_DecodeUpdate(&ctx, buf, &outl,(unsigned char *)indatas, indataslen) == -1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		free(buf);
		return false;
	}

	if(EVP_DecodeFinal(&ctx, &(buf[outl]), &i) == -1)
	{
		NEWPKIerr(CRYPTO_ERROR_TXT, ERROR_BAD_DATAS);
		free(buf);
		return false;
	}

	(*outdatas)=(char *)buf;
	(*outdataslen)=i+outl;
	return true;
}
