/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PEM_DER.h: interface for the PEM_DER class.
//
//////////////////////////////////////////////////////////////////////

#ifndef PEM_DER_H
#define PEM_DER_H



#include <PKI_ERR.h>

#include <openssl/evp.h>

#define PEM_BUFSIZE 1024

/*!
  This class performs PEM encoding/decoding
*/
class PEM_DER  
{
public:
	/*! \brief This is the constructor.
	 */
	PEM_DER();
	
	/*! \brief This is the destructor.
	 */
	virtual ~PEM_DER();

	/*! \brief This function decodes from PEM.
	 *  \param indatas [IN] Pointer to the datas to decode.
	 *  \param indataslen [IN] Length of the datas pointed by indatas.
	 *  \param outdatas [OUT] Pointer to the decoded datas, it must be freed by the calling function.
	 *  \param outdataslen [OUT] Length of the datas pointed by outdatas.
	 *  \return true on success, false on failure.
	 */
	bool Pem2Der(const char * indatas, int indataslen, char ** outdatas, int * outdataslen);

	/*! \brief This function encodes into PEM.
	 *  \param indatas [IN] Pointer to the datas to encode.
	 *  \param indataslen [IN] Length of the datas pointed by indatas.
	 *  \param outdatas [OUT] Pointer to the encoded datas, it must be freed by the calling function.
	 *  \param outdataslen [OUT] Length of the datas pointed by outdatas.
	 *  \return true on success, false on failure.
	 */
	bool Der2Pem(const char * indatas, int indataslen, char ** outdatas, int * outdataslen);

private:
};

#endif

