/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// Entity_CA.h: interface for the Entity_CA class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_CA_H
#define ENTITY_CA_H


#include "Entity.h"
#include "Entity_CA_ASN1.h"
#include "CaStore.h"


#include "CA_Handler.h"
#include "PlugCA.h"

/*!
	This class represents a CA Entity
*/
class Entity_CA : public Entity  
{
public:
	void PrintInfo(FILE * out);
	Entity_CA(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_CA();

	bool Requester_OnNewResponse(const Asn1OctetString & transactionID, const X509_PUBKEY * sender, const NewpkiResponse & Response);
	bool Responder_ValidateRequest(const NewpkiRequest & Request, const X509_PUBKEY * Requester, mString & SenderName);
	bool Responder_TreatRequest(const NewpkiRequest & Request, const mString & SenderName, NewpkiResponse & Response);

	bool Load();
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool Upgrade(const char * Version);
	bool Init(const EntitySignatureResp & init_datas);
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);

	/*! \brief This function returns the list of types of logs the entity generates.
	 *  \param cLogsType [OUT] The list.
	 */
	static void LogsTypeGet(mVector<unsigned long> & cLogsType);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);
private:
	bool PrepareConfToWrite();
	bool PublishRevocation(const char * ldap_uid, const PKI_CERT & Cert, time_t rev_date);
	bool PublishCrl(const PKI_CRL & crl);
	bool PublishCert(const char * ldap_uid, const PKI_CERT & Cert);
	bool PublishDatas(const char * ldap_uid, const char * object, const NewpkiPubRequestBody & PubBody);

	bool GenerateCRL(COMMAND_PARAMETERS);
	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);
	
	static bool Private_ParseAdminCommand(bool ExecuteCmd, Entity * me_this, mVector<unsigned long> &  mLogsType, AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest, UserHandle & hUser);

	bool GetStatus(COMMAND_PARAMETERS);
	bool GetCaP7b(COMMAND_PARAMETERS);
	bool CreateRootCa(COMMAND_PARAMETERS);
	bool CreateChildCa(COMMAND_PARAMETERS);
	bool ImportChildCaCert(COMMAND_PARAMETERS);
	bool ImportCaP12(COMMAND_PARAMETERS);
	bool EnumCerts(COMMAND_PARAMETERS);
	bool EnumCrls(COMMAND_PARAMETERS);
	bool SignCSR(COMMAND_PARAMETERS);
	bool RevokeCert(COMMAND_PARAMETERS);
	bool GetLocalConf(COMMAND_PARAMETERS);
	bool SuspendCert(COMMAND_PARAMETERS);
	bool UnsuspendCert(COMMAND_PARAMETERS);

	
	bool ParseNewConf();

	bool Private_SignCSR(const char * ldap_uid, const PKI_CSR & csr, unsigned long validity, PKI_CERT & Cert);
	bool Private_GenerateCRL(PKI_CRL & Crl);
	bool Private_RevokeCERT(const char * ldap_uid, unsigned long serial, CERT_STATE & CertStatus);
	bool Private_SuspendCERT(const char * ldap_uid, unsigned long serial, CERT_STATE & CertStatus);
	bool Private_UnsuspendCERT(const char * ldap_uid, unsigned long serial, CERT_STATE & CertStatus);

	bool OnNewRequest(const PKI_CSR & Csr);
	bool OnNewCertificate(const char * ldap_uid, const PKI_CERT & Cert);
	bool OnNewRevocation(const char * ldap_uid, const PKI_CERT & Cert, time_t rev_date);
	bool OnNewCRL(const PKI_CRL & crl);

	static void ThreadGenerateCRL(const NewpkiThread * Thread, void *param);
	static void ThreadRepublish(const NewpkiThread * Thread, void *param);
	bool ProceedWithRequest(const NewpkiRequest & req, NewpkiResponse & resp, LOG_MESSAGE_TYPE & LogType, mString & ObjectName, mString & Err);
	bool ProceedWithCertification(const NewpkiCertRequest & cert_request, NewpkiResponse & currResponse);
	
	LocalCaConf myConf;

	NewpkiThread hThreadGenerateCRL;
	NewpkiThread hThreadRepublish;
	
	CA_Handler * m_InternalCa;
	HashTable_String m_PlugOptions;
	HashTable_String m_Exts;
	HashTable_String m_CrlExts;
	long m_crldays;
	long m_crlhours;
	PlugCA * m_PlugCA;
	bool m_keepCsrExts;
	bool m_csrExtsOverwrite;

	CaStore CaPublicationStore;
	DECLARE_COMMAND_PARSER(Entity_CA);
};

#endif
