/* $Id: dired.c,v 1.4 2000/09/21 17:28:29 amura Exp $ */
/* dired module for mg 2a	*/
/* by Robert A. Larson		*/

/*
 * $Log: dired.c,v $
 * Revision 1.4  2000/09/21 17:28:29  amura
 * replace macro _WIN32 to WIN32 for Cygwin
 *
 * Revision 1.3  2000/07/22 17:54:09  amura
 * fix typo bug
 *
 * Revision 1.2  2000/06/27 01:49:42  amura
 * import to CVS
 *
 * Revision 1.1  1999/05/21  02:45:06  amura
 * Initial revision
 *
 */

#include "config.h"	/* 90.12.20  by S.Yoshida */
#include "def.h"

#ifndef NO_DIRED

BUFFER *dired_();
#ifndef strncpy
extern char* strncpy();
#endif

/*ARGSUSED*/
dired(f, n)
int f, n;
{
    char dirname[NFILEN];
    BUFFER *bp;
#ifdef	EXTD_DIR
    int i;

    ensurecwd();
    edefset(curbp->b_cwd);
#endif

    dirname[0] = '\0';
#ifndef NO_FILECOMP	/* 90.04.04  by K.Maeda */
    if(eread("Dired: ", dirname, NFILEN, EFNEW | EFCR | EFFILE) == ABORT)
#else	/* NO_FILECOMP */
    if(eread("Dired: ", dirname, NFILEN, EFNEW | EFCR) == ABORT)
#endif	/* NO_FILECOMP */
	return ABORT;
    if((bp = dired_(dirname)) == NULL) return FALSE;
    curbp = bp;
#ifdef	EXTD_DIR
    strncpy(curbp->b_cwd, dirname, NFILEN-1);
    i = strlen(dirname) - 1;
#ifdef BDC2
    if (curbp->b_cwd[i] != BDC1 && curbp->b_cwd[i] != BDC2) {
	curbp->b_cwd[i+1] = BDC2;
	curbp->b_cwd[i+2] = '\0';
    }
#else
    if (curbp->b_cwd[i] != BDC1) {
	curbp->b_cwd[i+1] = BDC1;
	curbp->b_cwd[i+2] = '\0';
    }
#endif
#endif	/* EXTD_DIR */
#ifdef	READONLY	/* 91.01.15  by K.Maeda */
    curbp->b_flag |= BFRONLY;
#endif	/* READONLY */
#ifdef FEPCTRL
    /* The following fepmode_off() is only effective if the provided
       fepcontrol supports a doubled fepmode_off() feature.  That is,
       the second call for the fepmode_off() is expected to change the
       previous fep mode as off, without doing any actual fep control
       since the fep mode has been already turned off by the first
       call of the function.  So, the succeeding fepmode_on() will not
       turn on the fep mode even if the previous fep mode was on
       before the first call of fepmode_off().

       If this feature is not provided, entering dired does not affect
       the fep mode.

       By Tillanosoft, Mar 21, 1999 */
    fepmode_off();
#endif
    return showbuffer(bp, curwp, WFHARD | WFMODE);
}

/*ARGSUSED*/
d_otherwindow(f, n)
int f, n;
{
    char dirname[NFILEN];
    BUFFER *bp;
    WINDOW *wp;

#ifdef	EXTD_DIR
    ensurecwd();
    edefset(curbp->b_cwd);
#endif

    dirname[0] = '\0';
#ifndef NO_FILECOMP	/* 90.04.04  by K.Maeda */
    if(eread("Dired other window: ", dirname, NFILEN, EFNEW | EFCR | EFFILE) == ABORT)
#else	/* NO_FILECOMP */
    if(eread("Dired other window: ", dirname, NFILEN, EFNEW | EFCR) == ABORT)
#endif	/* NO_FILECOMP */
	return ABORT;
    if((bp = dired_(dirname)) == NULL) return FALSE;
#ifdef	READONLY	/* 91.01.15  by K.Maeda */
    bp->b_flag |= BFRONLY;
#endif	/* READONLY */
    if((wp = popbuf(bp)) == NULL) return FALSE;
    curbp = bp;
    curwp = wp;
    return TRUE;
}

/*ARGSUSED*/
d_del(f, n)
int f, n;
{
    if(n < 0) return FALSE;
    while(n--) {
	if(llength(curwp->w_dotp) > 0)
	    lputc(curwp->w_dotp, 0, 'D');
	if(lforw(curwp->w_dotp) != curbp->b_linep)
	    curwp->w_dotp = lforw(curwp->w_dotp);
    }
    curwp->w_flag |= WFEDIT | WFMOVE;
    curwp->w_doto = 0;
    return TRUE;
}

/*ARGSUSED*/
d_undel(f, n)
int f, n;
{
    if(n < 0) return d_undelbak(f, -n);
    while(n--) {
	if(llength(curwp->w_dotp) > 0)
	    lputc(curwp->w_dotp, 0, ' ');
	if(lforw(curwp->w_dotp) != curbp->b_linep)
	    curwp->w_dotp = lforw(curwp->w_dotp);
    }
    curwp->w_flag |= WFEDIT | WFMOVE;
    curwp->w_doto = 0;
    return TRUE;
}

/*ARGSUSED*/
d_undelbak(f, n)
int f, n;
{
    if(n < 0) return d_undel(f, -n);
    while(n--) {
	if(llength(curwp->w_dotp) > 0)
	    lputc(curwp->w_dotp, 0, ' ');
	if(lback(curwp->w_dotp) != curbp->b_linep)
	    curwp->w_dotp = lback(curwp->w_dotp);
    }
    curwp->w_doto = 0;
    curwp->w_flag |= WFEDIT | WFMOVE;
    return TRUE;
}

/*ARGSUSED*/
d_flag(f, n)
int f, n;
{
  struct LINE *lp;
  char flag = (f & FFARG) ? ' ' : 'D';
  int nflags = 0, len;

  lp = curbp->b_linep;
  do {
    len = llength(lp);
    if (len > 0 && lgetc(lp, len - 1) == '~') {
      lputc(lp, 0, flag);
      nflags++;
    }
    lp = lforw(lp);
  } while (lp != curbp->b_linep);
  curwp->w_flag |= WFEDIT | WFMOVE;
  ewprintf(flag == 'D' ? 
	   "%d backup file%s flagged." : "%d backup file%s unmarked.",
	   nflags, nflags == 1 ? "" : "s");
  return TRUE;
}

/*
 * unified routine for d_findfile and d_ffotherwindow
 */

static
d_fileopen(f, n, popup)
int f, n, popup;
{
    char *fname;
    register BUFFER *bp;
    register int s;
    register WINDOW *wp;
    BUFFER *findbuffer();

    if((s = d_makename(curwp->w_dotp, &fname)) == ABORT) return FALSE;
    if ((bp = (s ? dired_(fname) : findbuffer(fname))) == NULL) {
      free(fname);
      return FALSE;
    }
#ifdef	READONLY	/* 91.01.16  by S.Yoshida */
    if (s) {			/* If dired buffer,	*/
	bp->b_flag |= BFRONLY;	/* mark as read-only.	*/
    }
#endif	/* READONLY */
    if (popup) {
      if ((wp = popbuf(bp)) == NULL) {
	free(fname);
	return FALSE;
      }
      curbp = bp;
      curwp = wp;
    }
    else {
      curbp = bp;
      if (showbuffer(bp, curwp, WFHARD) != TRUE) {
	free(fname);
	return FALSE;
      }
    }
    if (bp->b_fname[0] != 0) {
      free(fname);
      return TRUE;
    }
    s = readin(fname);
#ifdef	READONLY	/* 91.01.16  by S.Yoshida */
    if (fchkreadonly(bp->b_fname)) { /* If no write permission, */
	    bp->b_flag |= BFRONLY;	 /* mark as read-only.      */
	    ewprintf("File is write protected");
    }
#endif	/* READONLY */
    free(fname);
    return s;
}

/*ARGSUSED*/
d_findfile(f, n)
int f, n;
{
  return d_fileopen(f, n, FALSE);
}

#ifdef READONLY
/*ARGSUSED*/
int
d_viewfile(f, n)
int f, n;
{
  int res;

  res = d_findfile(f, n);
  if (res) {
    curbp->b_flag |= BFRONLY; /* set read-only bit. */
  }
  return res;
}
#endif

/*ARGSUSED*/
d_ffotherwindow(f, n)
int f, n;
{
  return d_fileopen(f, n, TRUE);
}

/*ARGSUSED*/
d_expunge(f, n)
int f, n;
{
    register LINE *lp, *nlp;
    char *fname;
    VOID lfree();

#ifdef	EXTD_DIR
    ensurecwd();
#endif

    for(lp = lforw(curbp->b_linep); lp != curbp->b_linep; lp = nlp) {
	nlp = lforw(lp);
	if(llength(lp) && lgetc(lp, 0) == 'D') {
	    switch(d_makename(lp, &fname)) {
		case ABORT:
		    ewprintf("Bad line in dired buffer");
		    return FALSE;
		case FALSE:
		    if(unlink(fname) < 0) {
			ewprintf("Could not delete '%s'", fname);
			free(fname);
			return FALSE;
		    }
		    free(fname);
		    break;
		case TRUE:
		    if(unlinkdir(fname) < 0) {
			ewprintf("Could not delete directory '%s'", fname);
			free(fname);
			return FALSE;
		    }
		    free(fname);
		    break;
	    }
	    lfree(lp);
	    curwp->w_flag |= WFHARD;
	}
    }
    return TRUE;
}

static char *
filename(path)
char *path;
{
  char *cp1;

  cp1 = path;
  while (*cp1 != 0) {
    ++cp1;
  }
  --cp1; /* insure at least 1 character ! */
#ifdef	BDC2
  while (cp1!= path && cp1[-1] != BDC1 && cp1[-1] != BDC2) {
    --cp1;
  }
#else
  while (cp1 != path && cp1[-1]!=BDC1) {
    --cp1;
  }
#endif
  return cp1;
}

/*ARGSUSED*/
d_copy(f, n)
int f, n;
{
    char *frname, toname[NFILEN], *fr;
    int stat;

#ifdef	EXTD_DIR
    ensurecwd();
#endif

    switch (d_makename(curwp->w_dotp, &frname)) {
    case TRUE:
      ewprintf("Not a file");
      free(frname);
      return FALSE;

    case ABORT:
      return FALSE;

    case FALSE:
      /* nothing to do */
      break;
    }
  
    fr = filename(frname);
#ifdef	EXTD_DIR
    edefset(curbp->b_cwd);
#endif

#ifndef NO_FILECOMP	/* 90.04.04  by K.Maeda */
    if((stat = eread("Copy %s to: ", toname, NFILEN, EFNEW | EFCR | EFFILE, fr))
#else	/* NO_FILECOMP */
    if((stat = eread("Copy %s to: ", toname, NFILEN, EFNEW | EFCR, fr))
#endif	/* NO_FILECOMP */
	!= TRUE) {
	free(frname);
	return stat;
    }
    stat = (copy(frname, toname) >= 0);
    free(frname);
    return stat;
}

/*ARGSUSED*/
d_rename(f, n)
int f, n;
{
    char *frname, toname[NFILEN], *fr;
    int stat;

#ifdef	EXTD_DIR
    ensurecwd();
#endif

    switch (d_makename(curwp->w_dotp, &frname)) {
    case TRUE:
      ewprintf("Not a file");
      free(frname);
      return FALSE;

    case ABORT:
      return FALSE;

    case FALSE:
      /* nothing to do */
      break;
    }

    fr = filename(frname);
#ifdef	EXTD_DIR
    edefset(curbp->b_cwd);
#endif

#ifndef NO_FILECOMP	/* 90.04.04  by K.Maeda */
    if((stat = eread("Rename %s to: ", toname, NFILEN, EFNEW | EFCR | EFFILE,
		     fr))
#else	/* NO_FILECOMP */
    if((stat = eread("Rename %s to: ", toname, NFILEN, EFNEW | EFCR, fr))
#endif	/* NO_FILECOMP */
	!= TRUE) {
      free(frname);
      return stat;
    }
    stat = (rename(frname, toname) >= 0);
    free(frname);
    return stat;
}

/*ARGSUSED*/
int
d_execute(f, n)
int f, n;
{
#ifdef WIN32
  char *fname;
  register int s;
  extern void WinExecute(char *);

  s = d_makename(curwp->w_dotp, &fname);
  if (s == ABORT) {
    return FALSE;
  }
  else if (s) { /* that is, fname points to a directory */
#if !defined(_WIN32_WCE) || 200 <= _WIN32_WCE
    goto noproblem;
#endif
    free(fname);
    return FALSE;
  }
  else {
noproblem:
    WinExecute(fname);
    free(fname);
    return TRUE;
  }
#else	/* not WIN32 */
  return TRUE;
#endif	/* WIN32 */
}

#endif	/* NO_DIRED */
