/*
 * Decompiled with CFR 0.152.
 */
package bossa.parser;

import bossa.parser.ParseException;
import bossa.parser.Parser;
import bossa.parser.Token;
import bossa.parser.TokenMgrError;
import bossa.syntax.LocatedString;
import bossa.syntax.Module;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import nice.tools.util.Chronometer;

public class JavaccParser
implements bossa.modules.Parser {
    public final boolean storeDocStrings;
    private static Chronometer chrono = Chronometer.make("Parsing");

    public JavaccParser(boolean storeDocStrings) {
        this.storeDocStrings = storeDocStrings;
    }

    public JavaccParser() {
        this(false);
    }

    public LocatedString readImports(Reader r, List imports, Collection opens) {
        chrono.start();
        try {
            Parser parser = new Parser(r);
            try {
                LocatedString locatedString = parser.readImports(imports, opens);
                return locatedString;
            }
            catch (ParseException e) {
                throw JavaccParser.reportError(e);
            }
        }
        finally {
            chrono.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Reader r, Module module, List definitions) {
        chrono.start();
        try {
            Parser parser = new Parser(r);
            try {
                parser.module(module, definitions, this.storeDocStrings);
            }
            catch (ParseException e) {
                throw JavaccParser.reportError(e);
            }
            catch (TokenMgrError e) {
                String message = e.getMessage();
                if (message.indexOf("<EOF>") != -1) {
                    if (parser.token_source.commentStart != null) {
                        User.error((Located)parser.token_source.commentStart, "Unclosed comment");
                    } else {
                        message = "Unexpected end of file";
                    }
                }
                User.error((Located)Location.nowhere(), message);
            }
        }
        finally {
            chrono.stop();
        }
    }

    public Object formalParameters(String parameters) {
        try {
            return JavaccParser.getParser(parameters).formalParameters(null);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private static Error reportError(ParseException e) {
        if (e.currentToken != null) {
            Token token = e.currentToken;
            if (token.next != null) {
                token = token.next;
            }
            throw User.error((Located)Parser.makeLocation(token), JavaccParser.removeLocation(e.getMessage()));
        }
        throw User.error(e.getMessage());
    }

    private static String removeLocation(String message) {
        int start = message.indexOf(" at line ");
        if (start == -1) {
            return message;
        }
        int end = message.indexOf(46, start);
        return message.substring(0, start) + message.substring(end, message.length());
    }

    private static Parser getParser(String toParse) {
        StringReader r = new StringReader(toParse);
        Parser parser = new Parser(r);
        return parser;
    }
}

