/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import java.util.ArrayList;
import mlsub.typing.lowlevel.BitMatrix;
import mlsub.typing.lowlevel.BitVector;
import mlsub.typing.lowlevel.Domain;
import mlsub.typing.lowlevel.K0;
import mlsub.typing.lowlevel.LowlevelUnsatisfiable;
import mlsub.typing.lowlevel.S;
import mlsub.typing.lowlevel.Separator;

final class DomainVector
extends ArrayList {
    int offset;
    int width;

    public DomainVector(DomainVector old) {
        super(old.size());
        this.offset = old.offset;
        this.width = old.width;
        for (int i = 0; i < old.size(); ++i) {
            Domain d = (Domain)old.get(i);
            if (d != null) {
                this.add(new Domain(d));
                continue;
            }
            this.add(null);
        }
    }

    public DomainVector(int offset, int width) {
        this.offset = offset;
        this.width = width;
    }

    public DomainVector(int offset, int width, int n) {
        super(n);
        for (int i = 0; i < n; ++i) {
            this.add(new Domain(width));
        }
        this.offset = offset;
        this.width = width;
    }

    public Domain getDomain(int x) {
        return (Domain)this.get(x - this.offset);
    }

    void truncate(int x) {
        this.removeRange(x, this.size());
    }

    private boolean isValidSoft(int x) {
        return x >= this.offset && x - this.offset < this.size() && this.getDomain(x) != null;
    }

    private boolean isGarbage(int x) {
        return x >= this.offset && x - this.offset < this.size() && this.getDomain(x) == null;
    }

    public void clear(int x) {
        this.set(x - this.offset, null);
    }

    public void reduce(int x, boolean unit, BitVector domain) throws LowlevelUnsatisfiable {
        S.assume(this.isValidSoft(x));
        Domain d = this.getDomain(x);
        d.reduce(unit, domain);
    }

    public void exclude(int x, BitVector domain) throws LowlevelUnsatisfiable {
        S.assume(this.isValidSoft(x));
        Domain d = this.getDomain(x);
        d.exclude(domain);
    }

    public void merge(int src, int dest) throws LowlevelUnsatisfiable {
        S.assume(this.isValidSoft(src));
        Domain srcDomain = this.getDomain(src);
        if (dest >= this.offset) {
            this.reduce(dest, srcDomain.containsUnit(), srcDomain);
        } else {
            S.assume(srcDomain.get(dest), src + " merged with " + dest);
        }
        this.clear(src);
    }

    public void exclude(int value) throws LowlevelUnsatisfiable {
        for (int i = 0; i < this.size(); ++i) {
            Domain d = (Domain)this.get(i);
            if (d == null) continue;
            d.exclude(value);
        }
    }

    public void move(int src, int dest) {
        S.assume(this.isValidSoft(src));
        S.assume(this.isGarbage(dest));
        this.set(dest - this.offset, this.getDomain(src));
        this.clear(src);
    }

    public void extend() {
        this.add(new Domain(this.width));
    }

    private boolean gfpSweep(BitMatrix R, BitMatrix C, int[] strategy, int dS, int direction) throws LowlevelUnsatisfiable {
        int s;
        boolean changed = false;
        BitVector ideal = new BitVector(this.width);
        boolean idealContainsUnit = false;
        int length = strategy.length;
        int n = s = dS > 0 ? 0 : length - 1;
        while (s >= 0 && s < length) {
            int x = strategy[s];
            Domain dx = this.getDomain(x);
            if (dx != null) {
                if (dx.isEmpty()) {
                    throw LowlevelUnsatisfiable.instance;
                }
                if (dx.needPropagation(direction)) {
                    changed = true;
                    ideal.clearAll();
                    idealContainsUnit = dx.containsUnit();
                    ideal.addProduct(R, dx);
                    for (int j = this.offset; j < this.offset + this.size(); ++j) {
                        Domain dj = this.getDomain(j);
                        if (dj == null || !C.get(x, j)) continue;
                        if (K0.debugK0) {
                            S.dbg.println("Reducing domain of " + j);
                            S.dbg.println("from " + dj);
                            S.dbg.println("with ideal of " + x + ": " + ideal);
                        }
                        dj.reduce(idealContainsUnit, ideal);
                    }
                }
            }
            s += dS;
        }
        return changed;
    }

    public void gfp(BitMatrix R, BitMatrix Rt, BitMatrix C, BitMatrix Ct, int[] strategy) throws LowlevelUnsatisfiable {
        boolean changed;
        do {
            changed = this.gfpSweep(R, C, strategy, 1, 0);
        } while (changed = this.gfpSweep(Rt, Ct, strategy, -1, 1) || changed);
    }

    void initGfpCardinals() {
        for (int i = 0; i < this.size(); ++i) {
            Domain d = (Domain)this.get(i);
            if (d == null) continue;
            d.initGfpCardinals();
        }
    }

    public int chooseDomain() {
        return this.chooseDomain(null);
    }

    public int chooseDomain(BitVector set) {
        int leastCard = Integer.MAX_VALUE;
        int least = Integer.MIN_VALUE;
        for (int i = 0; i < this.size(); ++i) {
            int card;
            Domain d;
            if (set != null && !set.get(i + this.offset) || (d = (Domain)this.get(i)) == null || (card = d.cardinal()) >= leastCard || card <= 1) continue;
            least = i + this.offset;
            leastCard = card;
        }
        return least;
    }

    public String dump() {
        Separator sep = new Separator(", ");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == null) continue;
            sb.append(sep).append("D(").append(i + this.offset).append(") = ").append(this.get(i));
        }
        return sb.toString();
    }
}

