/**************************************************************************/
/*                             N I C E                                    */
/*        A simple imperative object-oriented research language           */
/*                   (c)  Daniel Bonniot 1999                             */
/*                                                                        */
/*  This program is free software; you can redistribute it and/or modify  */
/*  it under the terms of the GNU General Public License as published by  */
/*  the Free Software Foundation; either version 2 of the License, or     */
/*  (at your option) any later version.                                   */
/*                                                                        */
/**************************************************************************/

// File    : NiceInterpreter.java
// Created : Thu Sep 07 18:03:49 2000 by Daniel Bonniot

package nice.tools.code;

import gnu.bytecode.*;
import gnu.expr.*;
import gnu.mapping.*;

/**
   Implements language dependant methods of gnu.expr.Interpreter.

   But Nice has no interpreter at the time being!

   @version $Date: 2001/10/30 15:38:24 $
   @author Daniel Bonniot
 */

public class NiceInterpreter extends gnu.expr.Interpreter
{
  public String getName()
  {
    return "Nice";
  }

  public Type getTypeFor(Class clas)
  {
    return Type.make(clas);
  }

  /** Must be called before code generation. */
  public static void init()
  {
    if (Interpreter.defaultInterpreter == null)
      {
	Interpreter.defaultInterpreter = new NiceInterpreter();
      }
  }
  
  /** Not implemented. */
  public Object read (InPort in)
    throws java.io.IOException, gnu.text.SyntaxException
  {
    throw new Error("Not implemented");
  }


  /** Not implemented. */
  public gnu.text.Lexer getLexer(InPort inp, gnu.text.SourceMessages messages)
  {
    throw new Error("Not implemented");
  }

  /** Not implemented. */
  public ModuleExp parse(Environment env, gnu.text.Lexer lexer)
    throws java.io.IOException, gnu.text.SyntaxException
  {
    throw new Error("Not implemented");
  }

  /** Not implemented. */
  public ModuleExp parseFile (InPort port, gnu.text.SourceMessages messages)
  {
    throw new Error("Not implemented");
  }

  /** Not implemented. */
  public gnu.lists.FormatToConsumer getFormat(boolean readable)
  {
    return null;
  }
}
