/* an editable number number
 */

/*

    Copyright (C) 1991-2003 The National Gallery

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 */

/*

    These files are distributed with VIPS - http://www.vips.ecs.soton.ac.uk

 */

/*
#define DEBUG
 */

#include "ip.h"

static ClassmodelClass *parent_class = NULL;

static void
number_finalize( GObject *gobject )
{
	Number *number;

#ifdef DEBUG
	printf( "number_finalize\n" );
#endif /*DEBUG*/

	g_return_if_fail( gobject != NULL );
	g_return_if_fail( IS_NUMBER( gobject ) );

	number = NUMBER( gobject );

	G_OBJECT_CLASS( parent_class )->finalize( gobject );
}

static xmlNode *
number_save( Model *model, xmlNode *xnode )
{
	Number *number = NUMBER( model );

	xmlNode *xthis;

	if( !(xthis = MODEL_CLASS( parent_class )->save( model, xnode )) )
		return( NULL );

	if( CLASSMODEL( model )->edited ) {
		if( !set_prop( xthis, "value", "%g", number->value ) ) 
			return( NULL );
	}

	return( xthis );
}

static gboolean
number_load( Model *model, 
	ModelLoadState *state, Model *parent, xmlNode *xnode )
{
	Number *number = NUMBER( model );

#ifdef DEBUG
	printf( "number_load: " );
	row_name_print( HEAPMODEL( number )->row );
	printf( "\n" );
#endif /*DEBUG*/

	assert( IS_RHS( parent ) );

	if( get_dprop( xnode, "value", &number->value ) )
		classmodel_set_edited( CLASSMODEL( model ), TRUE );

	return( MODEL_CLASS( parent_class )->load( model, 
		state, parent, xnode ) );
}

/* Update Number from heap.
 */
static gboolean
number_class_get( Classmodel *classmodel, PElement *root )
{
        Number *number = NUMBER( classmodel );
	char caption[MAX_STRSIZE];
	double value;

#ifdef DEBUG
	printf( "number_class_get: " );
	row_name_print( HEAPMODEL( number )->row );
	printf( "\n" );
#endif /*DEBUG*/

	if( !class_get_member_string( root, MEMBER_CAPTION, 
		caption, MAX_STRSIZE ) ||
		!class_get_member_real( root, MEMBER_VALUE, &value ) )
		return( FALSE );
	iobject_set( IOBJECT( classmodel ), NULL, caption );
	number->value = value;

	return( CLASSMODEL_CLASS( parent_class )->class_get( 
		classmodel, root ) );
}

/* Make a new "fn value" application.
 */
static gboolean
number_class_new( Classmodel *classmodel, PElement *fn, PElement *out )
{
	Heap *heap = reduce_context->heap;
	Number *number = NUMBER( classmodel );
	PElement rhs;

#ifdef DEBUG
	printf( "number_class_new: " );
	row_name_print( HEAPMODEL( number )->row );
	printf( "\n" );
#endif /*DEBUG*/

	/* Make application nodes.
	 */
	heap_appl_init( out, fn );
	if( !heap_appl_add( heap, out, &rhs ) ||
		!heap_string_new( heap, 
			IOBJECT( classmodel )->caption, &rhs ) ||
		!heap_appl_add( heap, out, &rhs ) ||
		!heap_real_new( heap, number->value, &rhs ) )
		return( FALSE );

	return( TRUE );
}

static void
number_class_init( NumberClass *class )
{
	GObjectClass *gobject_class = (GObjectClass *) class;
	ModelClass *model_class = (ModelClass *) class;
	ClassmodelClass *classmodel_class = (ClassmodelClass *) class;

	parent_class = g_type_class_peek_parent( class );

	gobject_class->finalize = number_finalize;

	/* Create signals.
	 */

	/* Init methods.
	 */
	model_class->view_new = numberview_new;
	model_class->save = number_save;
	model_class->load = number_load;

	classmodel_class->class_get = number_class_get;
	classmodel_class->class_new = number_class_new;

	/* Static init.
	 */
	model_register_loadable( MODEL_CLASS( class ) );
}

static void
number_init( Number *number )
{
	number->value = 0.0;

	iobject_set( IOBJECT( number ), CLASS_NUMBER, NULL );
}

GType
number_get_type( void )
{
	static GType type = 0;

	if( !type ) {
		static const GTypeInfo info = {
			sizeof( NumberClass ),
			NULL,           /* base_init */
			NULL,           /* base_finalize */
			(GClassInitFunc) number_class_init,
			NULL,           /* class_finalize */
			NULL,           /* class_data */
			sizeof( Number ),
			32,             /* n_pnumberlocs */
			(GInstanceInitFunc) number_init,
		};

		type = g_type_register_static( TYPE_CLASSMODEL, 
			"Number", &info, 0 );
	}

	return( type );
}

Classmodel *
number_new( Rhs *rhs )
{
	Number *number;

	number = NUMBER( g_object_new( TYPE_NUMBER, NULL ) );
	icontainer_child_add( ICONTAINER( rhs ), ICONTAINER( number ), -1 );

	return( CLASSMODEL( number ) );
}
