
/*
 * getfolder.c -- get the current or default folder
 *
 * $Id: getfolder.c,v 1.2 2002/07/02 22:09:14 kenh Exp $
 *
 * This code is Copyright (c) 2002, by the authors of nmh.  See the
 * COPYRIGHT file in the root directory of the nmh distribution for
 * complete copyright information.
 */

#include <h/mh.h>


char *
getfolder(int wantcurrent)
{
    register char *folder;

    /*
     * If wantcurrent == 1, then try the current folder first
     */
    if (wantcurrent && (folder = context_find (pfolder)) && *folder != '\0')
	return folder;

    /*
     * Else try the Inbox profile entry
     */
    if ((folder = context_find (inbox)) && *folder != '\0')
	return folder;

    /*
     * Else return compile time default.
     */
    return defaultfolder;
}
