////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements Blowfish encrypted NoteCase HTML format I/O
////////////////////////////////////////////////////////////////////////////

#ifndef FORMATENCHTML_H__
#define FORMATENCHTML_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "FormatHtml.h"
#include "types.h"	//INT64

//
// encrypted HTML format support
//

class FormatEncHTML : public FormatHTML
{
public:
	FormatEncHTML();
	virtual ~FormatEncHTML();
	
	virtual int  Load(const char *szFile, NoteDocument &doc);
	virtual bool Save(const char *szFile, NoteDocument &doc);
	virtual int  GetFormat(){ return FORMAT_HTML_ENC; };
	
	void SetPassword(const char *szPass);
	
protected:
	std::string m_strPass;
	INT64 m_nOrigSize;	//unencrypted file size
};

#endif // FORMATENCHTML_H__
