////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Implements Gjots2 format I/O (reading only)
////////////////////////////////////////////////////////////////////////////

#ifndef FormatGjots2_H__
#define FormatGjots2_H__

#include "HtmlParser.h"
#include "NoteFormatIO.h"

class NoteFormatIO;

class FormatGjots2 : public NoteFormatIO
{
public:
	FormatGjots2();
	~FormatGjots2();

	virtual int  Load(const char *szFile, NoteDocument &doc);
	virtual bool Save(const char *szFile, NoteDocument &doc);
	virtual int  GetFormat(){ return FORMAT_GJOTS2; };

protected:
	bool ParseLine(const char *szBuffer);

protected:
	//document parse info
	int m_nCurParentID;
	int m_nCurNodeID;
	int m_nDocParseState;
};

#endif

