////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Class describing single document node
////////////////////////////////////////////////////////////////////////////

#include "NoteNode.h"


NoteNode::NoteNode()
{
	m_nIconType = ICON_NONE;
	m_nSelStart = 0;
	m_nSelEnd = 0;
}

NoteNode::~NoteNode()
{
}

void NoteNode::Clear()
{
	m_strTitle.erase(m_strTitle.begin(), m_strTitle.end());
	m_strText.erase(m_strText.begin(), m_strText.end());
	m_nSelStart = 0;
	m_nSelEnd = 0;
}

std::string NoteNode::GetTitle()
{
	return m_strTitle;
}

std::string NoteNode::GetText()
{
	return m_strText;
}

void NoteNode::SetTitle(const char *szTitle)
{
	m_strTitle = szTitle;
}

void NoteNode::SetText(const char *szText)
{
	m_strText = szText;
}

void NoteNode::SetSelStart(unsigned int selStart)
{
	m_nSelStart = selStart;
}

void NoteNode::SetSelEnd(unsigned int selEnd)
{
	m_nSelEnd = selEnd;
}

unsigned int NoteNode::GetSelStart()
{
	return m_nSelStart;
}

unsigned int NoteNode::GetSelEnd()
{
	return m_nSelEnd;
}
