////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Class describing single document node
////////////////////////////////////////////////////////////////////////////

#ifndef NOTENODE_H__
#define NOTENODE_H__

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <string>

#define ICON_NONE			-2
#define ICON_CUSTOM			-1
#define ICON_INTERNAL_FIRST 0
#define ICON_INTERNAL_LAST	5

//TOFIX copy constructor, init values

class NoteNode  
{
public:
	NoteNode();
	virtual ~NoteNode();

	void Clear();

	std::string GetTitle();
	std::string GetText();

	void SetTitle(const char *szTitle);
	void SetText(const char *szText);
	bool IsRootNode(){ return -1 == m_nParentID; }

	// get and set cursor position and selection bound
	void SetSelStart(unsigned int selStart);
	void SetSelEnd(unsigned int selEnd);
	unsigned int GetSelStart();
	unsigned int GetSelEnd();

public:
	int m_nID;		// node ID value (unique in a single document during its entire lifetime)
	int m_nParentID;	// node parent ID value (defines node hierarchy)
	int m_nSiblingIdx;	// index that orders the nodes having the same parent
	
	//additional node attributes
	int m_nIconType;
	std::string m_strIconFile;

protected:
	std::string m_strTitle;	// node title
	std::string m_strText;	// node text

	// remember cursor position and selection bound
	unsigned int m_nSelStart, m_nSelEnd;
};

#endif // NOTENODE_H__
