////////////////////////////////////////////////////////////////////////////
// NoteCase notes manager project <http://notecase.sf.net>
//
// This code is licensed under BSD license.See "license.txt" for more details.
//
// File: Class implements SHA1 hashing algorithm
////////////////////////////////////////////////////////////////////////////

/*
	100% free public domain implementation of the SHA-1 algorithm

	=== Test Vectors (from FIPS PUB 180-1) ===

	"abc"
		A9993E36 4706816A BA3E2571 7850C26C 9CD0D89D

	"abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"
		84983E44 1C3BD26E BAAE4AA1 F95129E5 E54670F1

	A million repetitions of "a"
		34AA973C D4C4DAA4 F61EEB2B DBAD2731 6534016F
*/

#ifndef _SHA1_H___
#define _SHA1_H___

#ifndef LITTLE_ENDIAN
 #define LITTLE_ENDIAN
#endif

#define MAX_FILE_READ_BUFFER 8000

class CSHA1
{
    public:
        enum { REPORT_HEX = 0, REPORT_DIGIT = 1 };

        CSHA1 ();
        virtual ~CSHA1 ();

        unsigned long m_state[5];
        unsigned long m_count[2];
        unsigned char m_buffer[64];
        unsigned char m_digest[20];

        void Reset ();

        void Update (unsigned char* data, unsigned int len);
        bool HashFile (char *szFileName);

        void Final ();
        void ReportHash (char *szReport, unsigned char uReportType = REPORT_HEX);
        void GetHash (unsigned char *uDest);

    private:
        void Transform (unsigned long state[5], unsigned char buffer[64]);
};

#endif
