/*
 * Copyright (c) 1996 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include "prototypes.h"
#include <stdio.h>
#include <string.h>
#include "tcl.h"
#include "tk.h"

#define NEW_SOLUTION
extern block *find_block_by_id();
extern line *find_line_by_id();
extern line *find_last_line();
extern block *active_block;
int minimise_updates=1;
/*extern block *init_block(); */
extern line *init_line();
extern void redisplay();
extern typeface tf;
extern page *p;
extern Tcl_Interp *interp;
extern u_int16 lkey;

extern void debug(const char *fmt,...);
extern queue sendq;		/* transmission queue */
extern struct timeval rtx_time;
extern MAX_DELETED_BLOCKS;
extern block *last_deleted_block[];	/* pointers to last 20 deleted blocks */
extern no_of_del_blocks;

extern u_int32 SrcID;

int deal_with_page_checksum();

int new_data = 0;

#define NOT_RECEIVED 0;
#define RECEIVED_SUM 1;

int sum_received = NOT_RECEIVED;

netpageinfo store_npi;

/*#define ABORT */

/*Seen page is set to TRUE when we see a page message from someone else,
   or get requested a page message from someone else.
   It's used to facilitate late joining */
int seen_page = FALSE;

/********************************************************************/
/*parse_line: called when we have a LINEMSG received from the net   */
/*            this fn decides what to do with the received line     */
/********************************************************************/
int parse_line(nl)
netline *nl;
{
    block *b;
    line *l;
    char command[80];
    char blockid[ID_LEN];
    char lineid[ID_LEN];
    char previd[ID_LEN];
    char nextid[ID_LEN];
    user_data modifier;
    int no_of_lines;
    struct timeval t;

    ntohtime(&(nl->lastmod), &t);
    ntohid(&(nl->blockid), blockid);
    ntohid(&(nl->lineid), lineid);
    ntohuser(&(nl->modifier), &modifier);

    if (ntohs(nl->linenum) == UNKNOWN_LINE) {
	/*The site sending a sliding key is telling me they've never heard 
	   of this line.  Remove it from the missing list so I don't ask
	   them again, and only add it back if I see it referenced by
	   someone else.

	   to do this properly we should keep track of who tells me they haven't
	   seen it, but getting told once will do for now. */
	if (is_in_missing_list(lineid))
	    rm_from_missing_list(lineid);
	return 0;
    }
    debug("--------\ngot line with block id: %s\n", blockid);
    debug("modifier: >%s<\n", modifier.username);

    b = find_block_by_id(p, blockid);	/* try to find the block that this line claims to be in */

    if (b == NULL) {		/* if we don't have the block that contains this line */
	/*this block is a new one on me... */
	/*we'll have to create it now, and fill in the details later */
	block *prev;
	block *new_block;

	user_data originator;
	set_null_name(&originator);	/* set a 'dummy' name */

	debug("New line in new block recv'ed\n");
	prev = p->last_block;	/* prev = pointer to last block in the page */

	add_to_missing_list(blockid, BLOCKMSG);		/* add our missing block to the missing list */
	/*   for request later on. */

	new_block = init_block(blockid,		/* create a dummy version of the block */
			       NORMAL,
			       nl->xpos,
			       ntohs(nl->ypos),
			       &t,
			       prev,
			       NULL,
			       &originator,
			       &(modifier),
			       &tf);

	set_null_name(&originator);

	sprintf(command, "set_block_posn %s %d %d", blockid, -1, -1);

	Tcl_Eval(interp, command);
	if (p->first_block == NULL)
	    p->first_block = new_block;
	p->last_block = new_block;
	b = new_block;


    }				/*end if we had to create a dummy block for the time being */
    /*OK, now we have a block to work with... */
    ntohid(&(nl->previd), previd);	/* previous and next line id's grabbed */
    ntohid(&(nl->nextid), nextid);	/*    from transmitted line data */

    debug("prev line: %s\n", previd);
    debug("next line: %s\n", nextid);

    l = find_line_by_id(lineid, b);	/* try to find the new line in our block */

    if (l == NULL) {		/* This is a new line for us */
	line *prevl;
	line *nextl;
	debug("Got a new line with id %s\n", lineid);

	if (strncmp(lineid, "NULL", ID_LEN) != 0)	/* if line has a lineid.. */
	    if (is_in_missing_list(lineid))
		rm_from_missing_list(lineid);	/* remove it from our missing list */

	prevl = find_line_by_id(previd, b);	/* find the previous line pointed to by this one */

	if (prevl == NULL) {	/* if we haven't got the previous line yet */
	    if (strncmp(previd, "NULL", ID_LEN) != 0) {
		add_to_missing_list(previd, LINEMSG);
		debug("*haven't seen the previous line\n");
	    }
	    /*check if we have seen the next line */
	    nextl = find_line_by_id(nextid, b);

	    if (nextl == NULL) {	/* if we haven't seen the previous or *//*  next lines - of the current line. */
		if (strncmp(nextid, "NULL", ID_LEN) != 0) {	/* if there should be a next line */
		    add_to_missing_list(nextid, LINEMSG);	/* add it to the missing list for request later on */
		    debug("*haven't seen the next line either\n");
		}
		/*OK, haven't seen either of the neightbouring lines */
		/*tag it onto the end of the list and worry about it later */
		find_best_place_for_line(b, ntohs(nl->linenum), &prevl, &nextl);

	    } else {
		prevl = nextl->prev_line;
	    }
	} else {		/* we have seen the previous line */
	    nextl = prevl->next_line;	/* if this is set up correctly then */
	    /*   this is handling insertion??? */

	    if (nextl == NULL) {	/* if we haven't got a next line *//* ********* mixing up nextl and nextid ******* */
		debug("*haven't seen the next line\n");
		add_to_missing_list(nextid, LINEMSG);	/* **** should this be prevl.nextid? */
	    } else if (strncmp(nextid, nextl->lineid, ID_LEN) != 0) {
		debug("*haven't got the correct next line\n");
		add_to_missing_list(nextid, LINEMSG);	/* if the next lines don't match up */
	    }
	}

	l = init_line(lineid, ntohs(nl->linenum), &t, prevl, previd, nextl, nextid);	/* create line */


	add_to_recent_list(lineid, &t, LINEMSG);		/* add line to the recent list */

	if ((prevl != NULL) && (strcmp(l->lineid, prevl->nextid) != 0)) {
	    /* if there are missing lines before this line */
	    debug("probably missing lines: l->linenum: %d\nprev->linenum: %d\n", l->linenum, prevl->linenum);
	    if ((l->linenum - prevl->linenum) > 0)
		l->missing_lines = (l->linenum - prevl->linenum) - 1;	/* set the correct no. of */
	    else {		/*   missing lines */
		l->missing_lines = 0;
		debug("missing lines before this line that can't be found");
	    }

	} else			/*  -- no missing lines -- */
	    l->missing_lines = 0;	/* else set the number of */
	/*   missing lines to 0 */

	if ((nextl != NULL) && (strcmp(l->nextid, nextl->lineid) != 0)	/* if missing lines after this */
	    &&(nextl->missing_lines > 0)) {	/*   line */
	    debug("still got some missing lines after this one...");
	    if ((nextl->linenum - ntohs(nl->linenum)) > 0)
		nextl->missing_lines = (nextl->linenum - ntohs(nl->linenum)) - 1;
	    else {
		debug("missing lines after this line that can't be found\n");
		nextl->missing_lines = 0;
	    }
	} else
	    /* if there aren't missing lines */ if (nextl != NULL) {
	    /*  after this line */
	    debug("no missing lines after this one...\n");
	    nextl->missing_lines = 0;	/* reset the missing lines counter */
	}
	/*   of the next line */
	else {			/* else no lines after this one */
	    debug("no lines after this one...\n");
	}


	if (nl->no_of_chars > 0)	/* copy line data into local data */
	    strncpy(l->line_data, nl->line_data, MAX_LINE_LEN);		/*   structure */
	else
	    strcpy(l->line_data, " ");

	l->no_of_chars = nl->no_of_chars;	/* copy line length */
	l->block = b;		/* set block */
	if (newer(&t, &(b->last_mod)))	/* copy latest modification times for */
	    time_copy(&t, &(b->last_mod));	/*  block and page */
	if (newer(&t, &(p->last_mod)))
	    time_copy(&t, &(p->last_mod));
	user_copy(&modifier, &(b->modifier));	/* update modifier */
	user_copy(&modifier, &(l->modifier));

	if ((b->first_line == NULL) || (prevl == NULL)) {
	    b->first_line = l;
	    debug("setting first line\n");
	}
	no_of_lines = count_lines(b);

	if (b->first_line == NULL) {
	    debug("no first line 1\n");
	}
	/*if(no_of_lines > b->no_of_lines) *//* Jim - I removed this so that linecount is always */
	/* correct locally */
	b->no_of_lines = no_of_lines;	/* ensure block has correct linecount */

	if ((b->xpos != nl->xpos) || (b->ypos != ntohs(nl->ypos))) {	/* if block has moved */
	    /*block has moved */
	    b->xpos = nl->xpos;
	    b->ypos = ntohs(nl->ypos);
	    /*need to redisplay whole block now */
	}
	if (prevl == NULL) {	/* if there is no previous line */
	    u_int16 lnum;

	    if (l->prev_line == NULL)
		lnum = 0;
	    else
		lnum = find_line_num(b, l->prev_line->lineid);

	    l->missing_lines = l->linenum - lnum;
	    /*now need to get those missing lines */
	} else if (ntohs(nl->linenum) != find_line_num(b, l->lineid)) {
	    /*someone inserted or deleted a line before this one,
	       and we missed the change */
	    /*need to request enough info to figure out where the
	       line was inserted or deleted */
	    debug("I missed a deletion or insertion before this line..\n");
	}
	/*fix up the line numbers so we don't get too confused */
	renumber_block(b);

	/*now need to force the update on screen */
	debug("new line: ->%s<-\n", l->line_data);


	if (b->first_line == NULL)
	    debug("no first line\n");
	if (b->status == DELETED)
	    debug("deleted block.\n");

	if (b->status != DELETED) {
			if ((active_block!=b) && (minimise_updates==1)) delayed_redisplay_block(b);
				else redisplay_block(b);
	}

    } else {			/* we have seen this line before. */

	debug("got a modified line\n");
	debug("b->no_of lines=%d\n", b->no_of_lines);

	if(newer(&t, &(l->last_mod))) {
		line *nextl;
	    line *prevl;
	    debug("nt=%ld,%ld  ot=%ld,%ld\n", &t.tv_sec, &t.tv_usec, (&l->last_mod)->tv_sec, (&l->last_mod)->tv_usec);
	    if (is_in_missing_list(lineid))
		rm_from_missing_list(lineid);	/* remove the line from the missing list */

	    strncpy(l->line_data, nl->line_data, MAX_LINE_LEN);		/* copy line into system's data store */
	    debug("data:%s\n", l->line_data);
	    l->no_of_chars = nl->no_of_chars;	/* update line length */
	    debug("line has %d (%d) chars\n", l->no_of_chars, strlen(l->line_data));
	    time_copy(&t, &(l->last_mod));	/* update line, block and page update times */
	    time_copy(&t, &(b->last_mod));
	    time_copy(&t, &(p->last_mod));
	    user_copy(&(modifier), &(l->modifier));	/* update line and block modifiers */
	    user_copy(&(modifier), &(b->modifier));

	    debug("2: prev line: %s\n", previd);
	    debug("2: next line: %s\n", nextid);
	    /*new lines may have been inserted before or after this one,
	       but we haven't received the new line yet... */
	    strcpy(l->nextid, nextid);	/* update line id's */
	    strcpy(l->previd, previd);

	    nextl = l->next_line;	/* update line pointers */
	    prevl = l->prev_line;

	    /*did we just get informed there should be a line before this
	       one that we haven't seen yet? */
	    if (l->linenum != LINE_DELETED) {	/* because deleted status stored in linenum */
		if ((prevl != NULL) && (strcmp(prevl->lineid, previd) != 0))	/* if the previous line is not the one we */
		    if ((l->linenum - prevl->linenum) > 0)	/*    were expecting.. */
			l->missing_lines = (l->linenum - prevl->linenum) - 1;	/* sort out the missing lines stuff */
	    }
	    /*unfortunately if we got informed there should be a line after
	       this one and haven't seen it yet, we also don't know how
	       many lines are missing - so assume we're only missing 1 */
	    if ((nextl != NULL) && (strcmp(nextl->lineid, nextid) != 0))
		if (nextl->missing_lines == 0)
		    nextl->missing_lines = 1;	/* ***** making assumptions */
	    /* about missing lines? */

	    if (nextl != NULL) {	/* produce debug missing line info */
		/* messages. */
		debug("l->missing_lines: %d\n", l->missing_lines);
		debug("nextl->missing_lines: %d\n", nextl->missing_lines);
		debug("nextl->lineid: %s\n", nextl->lineid);
	    }
	    debug("l->nextid: %s\n", l->nextid);
	    /* "OK" for backward compatibility */
	    if ((nextl != NULL) && (nextl->missing_lines != 0)	/* could this be the problem? */
		&&((strncmp(l->nextid, nextl->lineid, ID_LEN) == 0)	/* if pointer to next line is ok and next */
		   ||(strncmp(l->nextid, "OK", ID_LEN) == 0))) {	/*  line thinks it has missing lines before it */
		debug("zeroing nextl->missing_lines\n");
		nextl->missing_lines = 0;	/* tell next line to forget about lines it */
	    }			/*   thinks are missing */
	    add_to_recent_list(lineid, &t, LINEMSG);	/* add this line to the list */
	    /*  of recent alterations. */
	    if ((b->xpos != nl->xpos) || (b->ypos != ntohs(nl->ypos))) {	/* if block has moved !** */
		/*block has moved */
		b->xpos = nl->xpos;
		b->ypos = ntohs(nl->ypos);
		/*need to redisplay whole block now */
	    }
	    debug("b->no_of_lines  = %d\n", b->no_of_lines);	/* OK HERE */

	    if (ntohs(nl->linenum) != find_line_num(b, l->lineid)) {	/* if our line's line number is *//*  inconsistent with the transmission */
		debug("Our line number is inconsistent-missing an ");
		if (ntohs(nl->linenum) > find_line_num(b, l->lineid))
		    debug("insertion\n");
		else
		    debug("deletion\n");

		/*someone inserted or deleted a line before this one,
		   and we missed the change */
		/*need to request enough info to figure out where the
		   line was inserted */
	    }
	    if ((ntohs(nl->linenum) == LINE_DELETED) && (l->linenum != LINE_DELETED)) {		/* if we have received a *//*  line deletion & have not */
		debug("got a LINE DELETION, >>%s<<\n", lineid);
		l->linenum = LINE_DELETED;
		delete_line(l, b);
	    }
	    /*now need to force the update on screen */
		if (b->status != DELETED) {
			if ((active_block!=b) && (minimise_updates==1)) delayed_redisplay_block(b);
				else redisplay_block(b);
		}


	} else {		/* received line is older than ours? */
	    /* this case is used if the received line is not newer than our current line */
	    /* therefore, some problems can arise when packets are transmitted one after another */
	    /* very quickly. The lines are as old as each other resulting in the latest line being */
	    /* discarded here. */

	    debug("must be an old packet - ignoring it\n");
	    debug("nt=%ld,%ld  ot=%ld,%ld\n", t.tv_sec, t.tv_usec, l->last_mod.tv_sec, l->last_mod.tv_usec);
	    debug("data: >>%s<<\n", l->line_data);
	    debug("id: %s\n", l->lineid);
	    if (is_in_missing_list(lineid))
		rm_from_missing_list(lineid);
	}
    }

    if (l == NULL) {
	debug("End of parse_line - no new line\n");
    } else {
	if (b->first_line == NULL) {
	    debug("parse_line b->first_line == null\n");
	}			/* endif */
    }

    new_data = 1;
    b->new_data = 1;

    return 0;
}


/********************************************************************/
/*parse_block: called when we have a BLOCKMSG received from the net */
/*            this fn decides what to do with the received block    */
/********************************************************************/
int parse_block(nb)
netblock *nb;
{
    int code;
    static char str[100000];
    block *b = NULL;
    block *new_block = NULL;
    char command[80];
    char blockid[ID_LEN];
    char previd[ID_LEN];
    char nextid[ID_LEN];
    user_data originator;
    user_data modifier;
    struct timeval t;

    ntohtime(&(nb->lastmod), &t);
    ntohid(&(nb->blockid), blockid);
    ntohid(&(nb->previd), previd);
    ntohid(&(nb->nextid), nextid);
    ntohuser(&(nb->originator), &originator);
    ntohuser(&(nb->modifier), &modifier);


    debug("got a block with id %s\n", blockid);

    b = find_block_by_id(p, blockid);	/* b is used to store line if we already have it */
    if (b == NULL) {
	/*This is a new block */
	/*block *new_block;                                       //moved above */
	block *prev = NULL;
	block *next = NULL;
	debug("got a new block\n");
	if (is_in_missing_list(blockid))
	    rm_from_missing_list(blockid);
#ifdef OLD_SOLUTION
	if (strncmp(previd, "NULL") != 0)
	    prev = find_block_by_id(p, previd);
	if (prev == NULL) {
	    /*we don't have the previous block either! */
	    if (strncmp(nextid, "NULL") != 0)
		next = find_block_by_id(p, nextid);
	    if (next == NULL) {
		/*we don't have the next block either! */
		/*OK, we just received a block, and we haven;t seen either
		   of the blocks that are supposed to neighbour it */
		/*we'll tag it on the end of our blocklist and hope the
		   neighbours turn up */
		/*eventually we'll have to request their re-transmission */
		if (p->last_block == NULL) {
		    /*This is the first block we've ever seen */
		    new_block = init_block(blockid,
					   NORMAL,
					   nb->xpos,
					   ntohs(nb->ypos),
					   t,
					   NULL,
					   NULL,
					   &(originator),
					   &(modifier),
					   &(nb->face));
		    p->first_block = new_block;
		    p->last_block = new_block;
		    sprintf(command, "set_block_posn %s %d %d",
			    blockid, nb->xpos, ntohs(nb->ypos));
		    Tcl_Eval(interp, command);
		    sprintf(command, "set_block_colour %s %d",
			    blockid, nb->face.colindex);
		    Tcl_Eval(interp, command);
		    sprintf(command, "set_block_font %s %d",
			    blockid, nb->face.fontindex);
		    Tcl_Eval(interp, command);
		    add_to_recent_list(blockid, t, BLOCKMSG);
		    debug("here\n");
		    return 0;
		} else {
		    prev = p->last_block;
		    next = NULL;
		}
	    } else {
		/*we had seen the next block but not the previous */
		prev = next->prev_block;
	    }
	}
	/* end if this was a new block */
	else {
	    /*we had seen the previous block */
	    next = prev->next_block;
	}
#endif
#ifdef NEW_SOLUTION
	next = NULL;
	prev = p->last_block;
	if (strncmp(previd, "NULL", ID_LEN) != 0)
	    if (find_block_by_id(p, previd) == NULL)
		if (!is_in_missing_list(previd))
		    add_to_missing_list(previd, BLOCKMSG);
	if (strncmp(nextid, "NULL", ID_LEN) != 0)
	    if (find_block_by_id(p, nextid) == NULL)
		if (!is_in_missing_list(nextid))
		    add_to_missing_list(nextid, BLOCKMSG);
#endif

	debug("init block id: %s\n", blockid);
	new_block = init_block(blockid,
			       nb->status,
			       nb->xpos,
			       ntohs(nb->ypos),
			       &t,
			       prev,
			       next,
			       &(originator),
			       &(modifier),
			       &(nb->face));

	new_block->new_data = 1;

	if (p->first_block == NULL)
	    p->first_block = new_block;

	p->last_block = new_block;
	add_to_recent_list(blockid, &t, BLOCKMSG);

	sprintf(command, "set_block_posn %s %d %d",
		blockid, nb->xpos, ntohs(nb->ypos));
	Tcl_Eval(interp, command);
	sprintf(command, "set_block_colour %s %d",
		blockid, nb->face.colindex);
	Tcl_Eval(interp, command);
	sprintf(command, "set_block_font %s %d",
		blockid, nb->face.fontindex);
	Tcl_Eval(interp, command);
#ifdef OLD_SOLUTION
	if (p->last_block == prev) {
	    /*we just added a block to the end of the list,
	       so update the end of list pointer in p */
	    p->last_block = new_block;
	}
#endif
	if (newer(&t, &(p->last_mod)))
	    time_copy(&t, &(p->last_mod));

	/* now deal with receiving new blocks, that were already deleted.. */
	if (new_block->status == DELETED) {

	    if (new_block->xpos == UNDELETED) {
		debug("received a new block - undeleted\n");
		/* don't add to deleted list, as already undeleted elsewhere */
	    }
	    /* end if */
	    else {
		debug("received a new block - deleted\n");
		/* add to deleted list so that we can undelete it ourselves. */
		new_block->status = NORMAL;	/* undelete it first, so that we can re-delete it */
		/* and then put it on the un-delete list */
		Tcl_SetVar(interp, "c_str", str, 0);
		sprintf(command, "set_block %s $c_str %d %d %d %d",
		    new_block->blockid, new_block->xpos, new_block->ypos,
		    new_block->face.fontindex, new_block->face.colindex);

		code = Tcl_Eval(interp, command);	/* display block on screen display */

		sprintf(command, "set_delete_status %s", new_block->blockid);
		Tcl_Eval(interp, command);
	    }			/* end else */

	}			/* end if deleted */
    } else {
	/*we've seen this block before */
	if (newer(&t, &(b->last_mod)) || is_a_null_name(&(b->originator)) || ((t.tv_sec == b->last_mod.tv_sec) && (t.tv_usec == b->last_mod.tv_usec))) {
	    debug("got a modified block\n");
	    b->new_data = 1;

	    if (is_in_missing_list(blockid))
		rm_from_missing_list(blockid);

	    /*b->no_of_lines=ntohs(nb->no_of_lines); *//* ??? Jim - I don't think we need this.. */
	    /* let's try keeping our own local linecount */
	    if ((b->xpos != nb->xpos) || (b->ypos != ntohs(nb->ypos))) {
		b->xpos = nb->xpos;
		b->ypos = ntohs(nb->ypos);
		sprintf(command, "set_block_posn %s %d %d",
			blockid, nb->xpos, ntohs(nb->ypos));
		Tcl_Eval(interp, command);
	    }
	    user_copy(&(originator), &(b->originator));
	    user_copy(&(modifier), &(b->modifier));
	    if (b->face.colindex != (nb->face.colindex)) {
		typeface_copy(&(nb->face), &(b->face));
		sprintf(command, "set_block_colour %s %d",
			blockid, nb->face.colindex);
		Tcl_Eval(interp, command);
	    }
	    if ( /*b->face.fontindex != (nb->face.fontindex) */ 1) {
		debug("setting block font to %d\n", nb->face.fontindex);
		typeface_copy(&(nb->face), &(b->face));
		sprintf(command, "set_block_font %s %d",
			blockid, nb->face.fontindex);
		Tcl_Eval(interp, command);
	    }
	    if ((nb->xpos) == UNDELETED) {
		int block_x;
		int undeleted = 0;	/* variable to use to stop our next for loop */
		debug("received an undeleted block\n");
		b->xpos = UNDELETED;
		/* remove this block from the deleted list.
		   remember, might not be on the top of the list.. */
		for (block_x = 0; ((block_x < no_of_del_blocks) && (undeleted == 0)); block_x++) {
		    if ((last_deleted_block[block_x]->blockid) == b->blockid) {
			int x;
			/* if we've found the block */
			/* copy down subsequent pointers, etc */
			debug("* * found undeleted block in our deleted list\n");
			for (x = block_x; x < (no_of_del_blocks - 1); x++) {
			    last_deleted_block[x] = last_deleted_block[x + 1];
			}	/* end for */

			/* now decrease the number of deleted blocks */
			no_of_del_blocks--;

			/*end this for loop */
			undeleted = 1;

		    }
		    /* end if */
		    else {
			debug("parse undelete block - didn't match %s, %s\n", last_deleted_block[block_x]->blockid, b->blockid);
		    }
		}		/* end for                                            */

		if (undeleted == 0) {
		    debug("* * didn't find undeleted blockin our deleted list * *\n");
		}		/* end if */
	    }			/* end if */
	    if (b->status != nb->status) {
		switch (nb->status) {
		case NORMAL:
		case LOCKED:
		    if (b->status != DELETED)
			b->status = nb->status;
		    else {
			/*if we see a modification to a deleted block,
			   need to ensure someone tells them, but we
			   also want anyone else who sees this message
			   to set their modification time to the same
			   value, and it must be greater than the person
			   who thinks this block still exists */
			t.tv_usec++;
			if (t.tv_usec >= 1000000) {
			    t.tv_sec++;
			    t.tv_usec = 0;
			}
		    }
		    break;
		case DELETED:
		    {

			/* jim changes - so that other sites can undo block deletes by */
			/*  another conference member. */

			debug("nb->xpos =%d \n", nb->xpos);
			debug("received a deleted block\n");

			sprintf(command, "set_delete_status %s", blockid);
			Tcl_Eval(interp, command);
		    }
			b->status = DELETED;
		    break;
		}
	    }
	    time_copy(&t, &(b->last_mod));
	    time_copy(&t, &(p->last_mod));
	    add_to_recent_list(blockid, &t, BLOCKMSG);
	} else {
	    debug("got an old block\n");
	    debug("nt=%lu,%lu  ot=%lu,%lu\n", t.tv_sec, t.tv_usec, b->last_mod.tv_sec, b->last_mod.tv_usec);
	    if ((nb->status == DELETED) & (b->status != DELETED)) {
		b->status = DELETED;
		sprintf(command, "set_delete_status %s", blockid);
		Tcl_Eval(interp, command);
	    }
	}
    }

    new_data = 1;

    return 0;
}				/* end of parse block */

u_int16 masks[17] =
{0x0, 0x1, 0x3, 0x7, 0xf, 0x1f, 0x3f, 0x7f, 0xff,
 0x1ff, 0x3ff, 0x7ff, 0xfff, 0x1fff, 0x3fff, 0x7fff, 0xffff};

int parse_rtx_advert(nrtxa, remote_addr)
netrtxadvert *nrtxa;
u_int32 remote_addr;
{
    struct timeval last_mod;
    struct timeval cur_time;
    struct timeval t;
    int received_sum = RECEIVED_SUM;

    ntohtime(&(nrtxa->lastmod), &t);
    seen_another_sliding_key(&t);
    get_cur_time(&rtx_time);
    debug("Received : Key %d, Mask %d :", (ntohs(nrtxa->key)), (masks[nrtxa->mask]));

    if (((ntohs(nrtxa->key)) & (masks[nrtxa->mask])) != (lkey & (masks[nrtxa->mask]))) {
	debug("Not matched\n");
	/*key didn't match */
	return -1;

    }
    debug("Matched\n");
    debug("sum_received == %d\n", sum_received);

    /* checksum management */
    if (sum_received == received_sum) {		/* 1 = RECEIVED */

	/*do csum stuff */
	/* 1. start a timer 5 +/- <3 seconds to call deal_with_page_checksum() */
	int time;
	get_cur_time(&cur_time);
	lbl_srandom(cur_time.tv_sec);	/* seed randomizer */
	time = (lbl_random() % 6000);	/* get random value 0->6000 */
	time = time - 3000;	/* r value from -3000 to 3000 */
	debug("dealing with a checksum packet we have already received\n");
	/* turn off sum received first */
	sum_received = NOT_RECEIVED

	/* send retransmission advert after 5 seconds random -3 -> +3 secs. */
	    Tk_CreateTimerHandler(5000 + time,
				(Tk_TimerProc *) deal_with_page_checksum,
				  (ClientData) 0);



    }				/* end if  */
    get_last_mod_time(p, &last_mod);
    if (seen_page == FALSE) {
	send_page_request(remote_addr);
	debug("haven't seen current page, requesting page\n");
	/*you only get to ask once.  if your packet gets lost, tough! */
	/*I'll change this later */
	seen_page = TRUE;
    } else if (number_missing() > 0) {
	debug("sending a specific rtx request\n");
	send_specific_rtx_request(remote_addr);
    } else if (newer(&t, &last_mod)) {
	/*we need a retransmission */
	debug("Asking for rtx after time t (t: %lu,%lu, lm: %lu,%lu\n",
	      t.tv_sec, t.tv_usec, last_mod.tv_sec, last_mod.tv_usec);
	send_rtx_request(remote_addr, &last_mod);
    }
    return 0;
}

int parse_rtx_request(nrtxr)
netrtxrequest *nrtxr;
{
    debug("Got an RTX REQUEST -");

    if (ntohl(nrtxr->source_uid)==SrcID) {
        debug(" addressed to me!\n");
        send_retransmissions(&(nrtxr->lastmod));
    } else {
        debug(" not addressed to me!\n");
        /* by design, we should be using the knowledge that someone else has requested */
        /* several items to ensure that we do not immediately request the same items. */
    }
    return 0;
}

int parse_rtx_specific_request(nrtxr)
netrtxspecificrequest *nrtxr;
{
    char id[ID_LEN];
    debug("Got an RTX SPECIFIC REQUEST - ");

    if (ntohl(nrtxr->source_uid)==SrcID) {
        u_int i;
        debug(" addressed to me!\n");
        for (i = 0; i < ntohl(nrtxr->no_of_items); i++) {	/* for each element in retransmission list */
            ntohid(&(nrtxr->ids[i]), id);
	        debug("request for %s\n", id);
            send_specific_retransmission(id);	/* queue that element for transmission */
        }
    } else {
        debug(" addressed to someone else");
        /*printf("It was addressed to %s\n", inet_ntoa(nrtxr->source.s_addr)); */
    }
    return 0;
}

int parse_page_request(netpagerequest * nrtxr)
{
    struct timeval t;
    debug("Got a PAGE_REQUEST ");

    if (ntohl(nrtxr->source_uid)==SrcID) {
        debug(" - addressed to me!\n");
        t.tv_sec = 0;
	    t.tv_usec = 0;
        /* retransmit everything (i.e. after time=0) */
	    send_retransmissions(&t);
    }
    debug(" - not addressed to me\n");
    seen_page = TRUE;
    return 0;
}

int parse_session_message(netsession * sm)
{

    struct timeval t;
    struct timezone tzp;
    gettimeofday(&t, &tzp);
    sm->textname[sm->textnamelen] = '\0';
    sm->textname[sm->textnamelen + 1] = '\0';
    add_receiver_to_participants(&(sm->ud), sm->textname, sm->col, &t);
    return 0;
}

int parse_leave_message(netsession * sm)
{
    debug("%s has left conference\n", sm->textname);
    rm_receiver_from_participants(&(sm->ud));
    return 0;
}

int parse_pointer(netpointer * np)
{
    char str[256];
    char id[ID_LEN];

    ntohid(&(np->id), id);
    if (ntohl(np->x) != DELETE_POINTER) {
	debug("move_shared_pointer %s %s %d %d %d %s\n", id, np->username,
	(int) ntohl(np->x), (int) ntohl(np->y), (int) np->col, np->style);

	sprintf(str, "move_shared_pointer %s %s %d %d %d %s", id, np->username,
	(int) ntohl(np->x), (int) ntohl(np->y), (int) np->col, np->style);

	Tcl_Eval(interp, str);
    } else {
	sprintf(str, "delete_shared_pointer %s", id);
	Tcl_Eval(interp, str);
    }
    return 0;
}

int parse_recent_list(netrecentadvert * nra)
{
    u_int i;
    char id[ID_LEN];
    struct timeval t;
    block *b;
    line *l;
    debug("parsing recent list\n");
    for (i = 0; i < ntohl(nra->no_of_entries); i++) {	/* for each element in the received - recent list? */
	ntohid(&(nra->entries[i].id), id);
	ntohtime(&(nra->entries[i].last_mod), &t);
	if (nra->entries[i].type == BLOCKMSG) {		/* if this element is a block */
	    debug("recent list contains block %s\n", id);
	    b = find_block_by_id(p, id);
	    if (b == NULL) {
		/* we don't have block with id 'id' so add it to missing list */
		add_to_missing_list(id, BLOCKMSG);
		continue;	/* go back to 'for' loop above, to check next element in recent list */
	    }
	    if (newer(&t, &(b->last_mod))) {	/* if t newer than our block b (with same id) */
		debug("recent list block more recent than mine: %s\n", id);
		debug("recent list time: %lu, %lu\n", t.tv_sec, t.tv_usec);
		debug("my block time: %lu, %lu\n", (b->last_mod).tv_sec, (b->last_mod).tv_usec);

		add_to_missing_list(id, BLOCKMSG);
	    } else if (newer(&(b->last_mod), &t)) {
		/* if we have a block newer than the 'current host' sending the summary packet. */

/*                              add_to_send_list(id, b, BLOCKMSG); */


		/* ok instead of using a send list - patch made to just broadcast the line straight away. */
		/*   (Jim) */
		/* perhaps - need some way of checking whether or not to broadcast the lines it carries. */
/*                              debug("We have a later version of a block received in recent list - transmit it\n"); */
/*                              debug("Our block time : %lu-%lu \nReceived block time %lu-%lu\n",b->last_mod.tv_sec,b->last_mod.tv_usec,t.tv_sec,t.tv_usec); */
/*                              queue_packet_for_sending(tx_fd, b, b->blockid, &sendq, BLOCKMSG); */

	    }
	} else if (nra->entries[i].type == LINEMSG) {	/* if this element is a line. */
	    debug("recent list contains line %s\n", id);

	    l = NULL;
	    b = p->first_block;
	    while (b != NULL) {	/* search through each block in the current page *//* for this line (entries[i]) */
		l = find_line_by_id(id, b);
		if (l == NULL) {	/* stop when pointing at a null block (i.e. - end of page) */
		    b = b->next_block;	/* didn't find line in this block so search for it */
		}
		/* in the next block. */
		else
		    break;
	    }
	    if (l == NULL) {	/* if we didn't find our own line with same id. */
		/* add to missing list for later request. */
		add_to_missing_list(id, LINEMSG);
	    } else {		/* if we have an older version of this line than the 'current host' (ours is out of date) */
		if (newer(&t, &(l->last_mod))) {
		    debug("Need a refresh: %s\n", id);
		    debug("%ld,%ld older that %ld,%ld\n", l->last_mod.tv_sec, l->last_mod.tv_usec,
			  t.tv_sec, t.tv_usec);
		    debug("recent list line more recent than mine: %s\n", id);
		    debug("recent list time: %lu, %lu\n", t.tv_sec, t.tv_usec);
		    debug("my line time: %lu, %lu\n", (l->last_mod).tv_sec, (l->last_mod).tv_usec);
		    add_to_missing_list(id, LINEMSG);	/* we want a newer copy of the line - so put it on */
		    /* our missing list for request later on. */
		} else if (newer(&(l->last_mod), &t)) {		/* we have a newer version of the line than the *//* current host */
		    /* commented out as there is no send list - how does the other site find out, therefore */
		    /* that we have a later version of this line - does it have to request is somehow - why */

		    /* see also commented out add_to_send */
/*                                      add_to_send_list(id, l, LINEMSG); */

		    /* to fix this - just queue line for transmission */
/*                                      debug("We have a later version of a line in recent list so transmit it\n"); */
/*                                      queue_packet_for_sending(tx_fd, l, l->lineid, &sendq, LINEMSG); */
		}
	    }
	} else {		/* the recent list contains an element with type != (line or block) */
	    ntohid(&(nra->entries[i].id), id);
	    debug("Got an unknown object type %d in recent advert from %s\n", nra->entries[i].type, id);
	}
    }
    return 0;
}

int deal_with_page_checksum()
{
    /* deal with page checksum.. */

/* 1. Calculate our own page checksum */
    calc_page_checksum(p);

    debug("dealing with the page_checksum now \n");

    /* 2. compare with the received checksum */
    if (strncmp(p->checksum, store_npi.checksum, 16) != 0) {

	debug("page checksums not equal local>%s<!=received>%s<\n", p->checksum, store_npi.checksum);
	/* 3. if different - start the re-request process */
	/*                      - get block checksums and compare */
	/*                      - re-request blocks and lines that we have earlier versions of */
	/*                      - re-transmit our later versions - REMEMBER we could have the correct */
	/*                      - version, not the other site. */

	/* FOR NOW - just use the other site's data if different from ours. */

	/* 3.1 Request the retransmission of all blocks */

	/* OK version 2 - request the transmission of information of all blocks at 
	   the current site. We are assuming here that the current site has more info 
	   than us.. */

	send_blockinfo_request2(store_npi.source_uid);
	debug("sending block info request for all blocks\n");

    } else {
	/* 4. if not different - we have the same page as the current site */
	/* so don't mess with it. */

    }

    return 0;
}				/* end function */

int parse_page_info(netpageinfo * npi)
{
    /* deal with page information broadcast from the current site. */
    /* NOTE - ensure that current site only sends this message when they have been */
    /* current site for a little while - or perhaps when we have had missing lines for */
    /*   too long. */

    debug("parsing a page info packet\n");

    if (npi->checksum_version != CHECKSUM_ALGORITHM_VERSION) {
	/* if we are using a different algorithm to the site sending us these checksums */
	debug("but not going to use page info packet as it uses the wrong algorithm version\n");
	debug("received version :%d: our version :%d:\n", npi->checksum_version, CHECKSUM_ALGORITHM_VERSION);
	return 0;
    }
    /* store checksum and source address received */

    strncpy(store_npi.checksum, npi->checksum, 18);
    store_npi.source_uid = ntohl(npi->source_uid);

    sum_received = RECEIVED_SUM;

    return 0;
}				/* end parse_page_info function */



int parse_blockinfo_request2(void)
{
    block *b;
    /* transmit blockinfo packets for all blocks.. */

    b = p->first_block;
    debug("parsing block info request (version 2) packet \n");

    while (b != NULL) {
	/* if we do have this block */

	/* check it's not already been sent */

	if (b->rtx_status != NORMAL_RTX) {
	    /*already been sent, so abort */
	    debug("already sent block info2 this round for %s and other blocks\n", b->blockid);
	} else {

	    b->rtx_status = INFO_RTX;
	    /* not already sent so */
	    /* send a blockinfo message */
	    send_blockinfo(b);
	    /* send block info to everyone - anyone else who has this block but has the */
	    /* wrong checksum will then change their blocks. */
	    /* This assumes that we have the latest version of the block.. */

	    debug("sending checksum info for block %s\n", b->blockid);
	}			/*end else */

	b = b->next_block;

    }

    return 0;
}



int parse_blockinfo_request(netblockinforequest * nbir)
{
    block *b;
    char id[ID_LEN];

    debug("parsing block info request packet\n");

    if (ntohl(nbir->source_uid)!=SrcID) {
        debug("block info request not directed to this site\n");
        return 0;		/* if the request is not directed towards this site.. */
    }
    /* someone has requested that we send blockinfo only for block with id nbir->blockid. */
    ntohid(&(nbir->blockid), id);

    b = find_block_by_id(p, id);
    if (b == NULL) {
	/* if we don't have this block */
	/* add it to the missing list */
	debug("don't have this block - putting it on missing list\n");
	add_to_missing_list(id, BLOCKMSG);

    } else {
	/* if we do have this block */

	/* check it's not already been sent */

	if (b->rtx_status != NORMAL_RTX) {
	    /*already been sent, so abort */
	    debug("already sent block info %s\n", id);
	    return 0;
	} else {

	    b->rtx_status = INFO_RTX;
	    /* not already sent so */
	    /* send a blockinfo message */

	    send_blockinfo(b);

	    /* send block info to everyone - anyone else who has this block but has the */
	    /* wrong checksum will then change their blocks. */
	    /* This assumes that we have the latest version of the block.. */

	    debug("we have block - sending info for block %s\n", id);

	}			/*end else */


    }

    return 0;
}				/* end parse_blockinfo_request */

int parse_blockinfo(netblockinfo * nbi)
{
    block *b;
    char id[ID_LEN];
    /* parse the block's info, if it has a different checksum, then the other site has a */
    /* 'better' copy of the block */

    debug("parsing a block info packet\n");
    /* someone has requested that we send blockinfo only for block with id nbir->blockid. */
    ntohid(&(nbi->blockid), id);
    debug("  for block with block id %s\n", id);

    b = find_block_by_id(p, id);
    if (b == NULL) {
	/* if we haven't got this block, then just request it immediately */

	send_block_rtx_request(id, nbi->source_uid);
    }
    /* end if */
    else {
	if (strncmp(nbi->checksum, b->checksum, 16) != 0) {
	    /* re-request transmission of this block (including all it's lines), */
	    /* send a block_rtx_request message */
	    debug("We have received a block information packet with a different checksum\n");
	    send_block_rtx_request(id, nbi->source_uid);

	    /* ** NOTE ** - if there are problems with the new updates conflicting with our */
	    /*  version of this block, we should perhaps delete our local store in some way, */
	    /*  without affecting the delete/undelete protocol. Just un-assign the memory ? */

	}
	/* end if */
	else {
	    debug("We have received a block information packet with the same checksum as us\n");
	}
    }				/* end else */
    return 0;
}				/* end parse_blockinfo */

int parse_blockrtx_request(netblockrtxrequest * nbrr)
{
    block *b;
    char id[ID_LEN];
    /* retransmit the block referred to by nbrr and then retransmit all of it's lines too */

    if (ntohl(nbrr->target_uid)!=SrcID) {
        debug("received a block rtx request, addressed to another site\n");
        return 0;   /* if this is not the site that retransmission is
	                   requested from. */
    }
    debug("parsing a block rtx request packet\n");
    /* someone has requested that we send blockinfo only for block with id nbir->blockid. */
    ntohid(&(nbrr->blockid), id);

    b = find_block_by_id(p, id);
    if (b == NULL) {
	/* we don't have this block - add it to our missing list. */
	add_to_missing_list(id, BLOCKMSG);
    } else {
	if (b->rtx_status == DATA_RTX) {
	    /* don't retransmit the block */
	} else {
	    line *l;
	    /* retransmit block with idno id, and all it's lines */
	    queue_packet_for_sending(b, b->blockid, &sendq, BLOCKMSG);
	    l = b->first_line;

	    while (l != NULL) {
		queue_packet_for_sending(l, l->lineid, &sendq, LINEMSG);
		l = l->next_line;
	    }			/* end while */

	    b->rtx_status = DATA_RTX;
	}			/*end else */
    }				/* end else */

    return 0;
}				/* end parse_blockrtx_request */
