/* main.c */

/*
    NUT nutrition software 
    Copyright (C) 1996, 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 by Jim Jozwiak.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "menu.h"
#include "food.h"
#include "meal.h"
#include "db.h"
#include "options.h"
#include <stdlib.h>

int mealdb_mealsperday;

int main(int argc, char *argv[])
{
food_root.next = NULL;
meal_root.next = NULL;
recipe_root.next = NULL;
theusual_root.next = NULL;
initializations();
if (argc > 1) make_filenames(argv[1]);
else make_filenames("");
if ( version(0) == MAJVERSION && version(1) == MINVERSION && read_food_db() )
 {
 read_meal_db();
 read_theusual_db();
 read_OPTIONS(0);
 }
else read_food_files();
if (version(0) != MAJVERSION || version(1) != MINVERSION)
 {
 if ((version(0) == 10 && version(1) < 8) || version(0) < 10)
  {
  if (mealdb_mealsperday > 0 && ((version(0) == 10 && version(1) < 8) || version(0) < 10)) options.mealsperday = mealdb_mealsperday;
  else options.mealsperday = 3;
  }
 }
if (version(0) != MAJVERSION || version(1) != MINVERSION) write_version();
menu();
exit(0);
}
