/*  explore-hid.c - this is a "stub" subdriver used to collect data
 *  about HID UPS systems that are not yet supported.
 *
 *  This subdriver will match any UPS, but only if the "-x explore" option
 *  is given.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "newhidups.h"
#include "explore-hid.h"
#include "extstate.h" /* for ST_FLAG_STRING */
#include "dstate.h"   /* for STAT_INSTCMD_HANDLED */
#include "common.h"
#include "main.h"

#define EXPLORE_HID_VERSION	"EXPLORE HID 0.1"

static usage_tables_t explore_utab[] = {
	hid_usage_lkp,
	NULL,
};

/* --------------------------------------------------------------- */
/*                 Data lookup table (HID <-> NUT)                 */
/* --------------------------------------------------------------- */

static hid_info_t explore_hid2nut[] =
{
  /* Server side variables */
  { "driver.version.internal", ST_FLAG_STRING, 5, NULL, NULL,
    DRIVER_VERSION, HU_FLAG_ABSENT | HU_FLAG_OK, NULL },
  { "driver.version.data", ST_FLAG_STRING, 11, NULL, NULL,
    EXPLORE_HID_VERSION, HU_FLAG_ABSENT | HU_FLAG_OK, NULL },

  /* end of structure. */
  { NULL, 0, 0, NULL, NULL, NULL, 0, NULL }
};

/* shutdown method for EXPLORE - unimplemented */
static int explore_shutdown(int ondelay, int offdelay) {
	upsdebugx(2, "Shutoff command not supported for this subdriver");
	return 0;
}

static char *explore_format_model(HIDDevice *hd) {
	return hd->Product;
}

static char *explore_format_mfr(HIDDevice *hd) {
	return hd->Vendor;
}

static char *explore_format_serial(HIDDevice *hd) {
	return hd->Serial;
}

/* this function allows the subdriver to "claim" a device: return 1 if
 * the device is supported by this subdriver, else 0. */
static int explore_claim(HIDDevice *hd) {
        if (testvar("explore")) {
                return 1;
        } else {
                return 0;
        }
}

subdriver_t explore_subdriver = {
	EXPLORE_HID_VERSION,
	explore_claim,
	explore_utab,
	explore_hid2nut,
	explore_shutdown,
	explore_format_model,
	explore_format_mfr,
	explore_format_serial,
};
