/* $Id: memory.c,v 1.19 2005/05/09 20:48:34 graziano Exp $ */

#include "memory.h"

#include "strutil.h"

void
MemoryUseSkill(	const char *options, 
		int *length, 
		SkillResult **results) {
	const char *c;
	char *tmp;
	char memoryType[7 + 1], opts[255 + 1];
	double res;
	int ret;

	tmp = GetOptionValue(options, "type", "passive");
	for(c = tmp; GETTOK(memoryType, c, ",", &c);) {
		vstrncpy(opts, sizeof(opts), 2, "type:", memoryType);
		if (strcmp(memoryType,"active") == 0) {
			ret = ActiveMemoryGetFree(&res);
		} else {
			ret = PassiveMemoryGetFree(&res);
		}
		AppendResult(freeMemory, opts, ret, res, 0, length, results);
	}
	FREE(tmp);
}

int
MemoryMonitorAvailable(const char *options) {
	static int available = -1;

	if (available == -1) {
		available = PassiveMemoryMonitorAvailable();
	}

	return available;
}
