#include "slap.h"
#include "external.h"
#include <ldap_pvt.h>

/* #include <string.h> */
#include <stdio.h>
#include "messages.h"
#include "protocol.h"
#include "host_protocol.h"
#include "register.h"
#include "nws_messages.h"
#include "nws_memory.h"
#include "hosts.h"
#include "nws_back_cache.h"
#include "nws_obj.h"
#include "nws_back_rb.h"

typedef nwsCacheConfig nwsBackConfig;

/* Prototypes */

Entry *
nws2entry(Backend *be, NWSobj *nobj, char *rdn);

Entry *
nwsBaseEntry(Backend *be, char *rdn, const char *base);

Entry *
nwsMeas2entry(Backend *be, nwsSeriesCache *nser, char *rdn);

Entry *
nwsForc2entry(Backend *be, nwsSeriesCache *nser, char *rdn); 

Entry *
getMeasEntry(Backend *be, nwsSeriesCache *nser, char *rdn);

Entry *
nwsColl2entry(Backend *be, nwsSeriesCache2Coll *nser_c2c,
			  nwsSeriesCache *nser, char *rdn);

nwsSeriesCache *
nws_get_series(nwsBackConfig *nbc, NWSobj *nobj);

int
nws_update_series(nwsBackConfig *nbc, struct nws_series_cache *series);

void *
nws_cache_getreg(void *v);

void
nws_back_archive(void *v);

void
nws_xml(void *v);

/* should move to obj cache header */
char * 
nws_get_objs(nwsBackConfig *nbc);

int 
nwsLdapInit(nwsBackConfig *nbc);

int
nws_cache_infer(nwsBackConfig *nbc, NWSobj *nws_obj_list, struct nws_series_collection *nser_coll);

int
nws_cache_relate(NWSobj *nws_obj_list,
				 struct nws_series_collection *nser_coll);
int
UnpackExperiments(const struct nws_memory_state *s,
                   const char *from,
                   size_t max_count,
                   NWSAPI_Measurement *to,
                   size_t *count);
