val encode_sql_t : Dbi.sql_t -> string

class statement :
  Dbi.connection ->
  Sqlite.db ->
  string ->
  object
    val mutable cur_vm : Sqlite.vm option
    val mutable next_row : string option array option
    val mutable executed : bool
    method connection : Dbi.connection
    method execute : Dbi.sql_t list -> unit
    method fetch1 : unit -> Dbi.sql_t list
    method fetch1hash : unit -> (string * Dbi.sql_t) list
    method fetch1int : unit -> int
    method fetch1string : unit -> string
    method fetch1bool : unit -> bool
    method fetchall : unit -> Dbi.sql_t list list
    method finish : unit -> unit
    method fold_left : ('a -> Dbi.sql_t list -> 'a) -> 'a -> 'a
    method fold_right : (Dbi.sql_t list -> 'b -> 'b) -> 'b -> 'b
    method iter : (Dbi.sql_t list -> unit) -> unit
    method map : (Dbi.sql_t list -> 'c) -> 'c list
    method names : string list
    method serial : string -> int64
  end

class connection :
  ?host:string ->
  ?port:string ->
  ?user:string ->
  ?password:string ->
  string ->
  object
    method close : unit -> unit
    method closed : bool
    method commit : unit -> unit
    method database : string
    method database_type : string
    method debug : bool
    method ex : string -> Dbi.sql_t list -> Dbi.statement
    method host : string option
    method id : int
    method password : string option
    method ping : unit -> bool
    method port : string option
    method prepare : string -> Dbi.statement
    method prepare_cached : string -> Dbi.statement
    method register_postrollback : (unit -> unit) -> Dbi.postrollback_handle
    method register_precommit : (unit -> unit) -> Dbi.precommit_handle
    method rollback : unit -> unit
    method set_debug : bool -> unit
    method unregister_postrollback : Dbi.postrollback_handle -> unit
    method unregister_precommit : Dbi.precommit_handle -> unit
    method user : string option
  end

val connect : ?host:string -> ?port:string ->
  ?user:string -> ?password:string -> string -> connection
(** Functional version of [new Dbi.connection ...] *)
val close : connection -> unit
(** Functional version of [dbh#close ()] *)
val closed : connection -> bool
(** Functional version of [dbh#closed] *)
val commit : connection -> unit
(** Functional version of [dbh#commit ()] *)
val ping : connection -> bool
(** Functional version of [dbh#ping ()] *)
val rollback : connection -> unit
(** Functional version of [dbh#rollback ()] *)
