(* $Id: simple-update.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  print_salaries "Old salary levels" dbh;

  (* Give the bosses a pay rise. *)
  let sth = dbh#prepare "update employees set salary = salary + 1000
                          where position <= 2" in
  sth#execute [];

  print_salaries "New salary levels" dbh
