#ifndef __WAVE_H
#define __WAVE_H

struct waveinfo
{
	unsigned long pos;
	unsigned long len;
	uint32_t rate;
	int stereo;
	int bit16;
};

extern unsigned char wpOpenPlayer(FILE *fp, int tostereo, int tolerance);
extern void wpClosePlayer(void);
extern void wpIdle(void);
extern void wpSetLoop(unsigned char s);
extern char wpLooped(void);
extern void wpPause(unsigned char p);
extern void wpSetAmplify(uint32_t amp);
extern void wpSetSpeed(uint16_t sp);
extern void wpSetVolume(unsigned char vol, signed char bal, signed char pan, unsigned char opt);
extern void wpGetInfo(struct waveinfo *);
extern uint32_t wpGetPos(void);
extern void wpSetPos(int32_t pos);

#endif
