%%NAME
%%  eimgzoom  - resize image
%%
%%SYNOPSIS
%%  [newimage newcolormap]=eimgzoom(image,colormap,scale)
%%
%%PARAMETER(S)
%%  newimage    new image matrix 
%%  newimage    new color table
%%  image       old image matrix 
%%  colormap    color table
%%  scale       scale factor (1=no resize, 2=double size, 0.5=half size)
%% 
% written by stefan.mueller@fgan.de (C) 2005
function [newimage,newcolormap]= eimgzoom (image,colormap,scale)
  if (nargin ~= 3)
    eusage('[newimage newcolormap] = eimgzoom(image,colormap,scale)');
  end

  eglobpar
  if exist('eFac')
    if isempty(eFac)
      einit;
    end
  else
    einit;
  end
  [imgH imgW]=size(image);
  imgFac=imgH/imgW;
  winFac=eWinHeight/eWinWidth;
  if winFac<imgFac
    eWinWidth=eWinHeight/imgFac;
    dpi=imgH*72/eWinHeight/eFac*scale;
  else
    eWinHeight=eWinWidth*imgFac;
    dpi=imgW*72/eWinWidth/eFac*scale;
  end
  if scale<1
    scale=1/scale/scale;
  end
  offsetX=scale*1.2*eWinWidth/imgW;
  offsetY=scale*1.2*eWinHeight/imgH;
  esavpar2
  eopen('imgzoom.eps.tmp',0,eWinWidth,eWinHeight)
  eframe(0,0,eWinWidth+offsetX,eWinHeight+offsetY,0,image,colormap);
  eclose(1,0);
  erespar2
  tmpfile=ebitmap(3,[dpi dpi],[eFileName '.ppm'],'imgzoom.eps.tmp');
  if colormap(1,1)<0
    newcolormap=-1;
    newimage=eimgread(tmpfile);
  else
    [newimage newcolormap]=eimgread(tmpfile);
  end
