/*

## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/
#include <vtkXOpenGLRenderWindow.h>
#undef Complex
#include <octave/oct.h>

// The following must be defined for recent versions of Octave.
#define TYPEID_HAS_CLASS
#include <octave/oct.h>
#include "octaviz.h"
	
DEFUN_DLD (vtkRaiseWindow, args, ,
"-*- texinfo -*-\n\
@deftypefn {Loadable Function} {} vtkRaiseWindow(@var{window})\n\
Raises the window specified.  Typically this window can be obtained by:\n\
\n\
f = vtk_figure(0);\n\
\n\
@var{window} = f.window;\n\
\n\
Some windows managers (e.g. KDE) will intercept this call.  You must\n\
turn off so-called ``Focus stealing prevention'' options in your windows manager for this\n\
function to work.\n\
@end deftypefn")
{
  octave_value retval;
  if ( args(0).type_id() != vtk_object::static_type_id() )
    {
      error("The parameter has to be vtkXOpenGLRenderWindow");
      return retval;
    }
  
  vtkObjectBase* vtk_pointer = reinterpret_cast<vtkObjectBase*>( args(0).uint_value() );
  
  if ( !vtk_pointer->IsA("vtkXOpenGLRenderWindow") )
    {
      error("The parameter has to be vtkXOpenGLRenderWindow");
      return retval;
    }
  
  vtkXOpenGLRenderWindow* window = reinterpret_cast<vtkXOpenGLRenderWindow*>(vtk_pointer);
  XRaiseWindow(window->GetDisplayId(), window->GetWindowId() );
  
  return retval;
}


/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; End: ***
*/
 
