// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#ifndef PROP_COLOR_H
#define PROP_COLOR_H

#include "property.h"
#include <FL/gl.h>

class Color : public Property {
public:
  Color(double r, double g , double b, double a) 
  {rgba[0]=r;rgba[1]=g;rgba[2]=b;rgba[3]=a;IsC=false;}
  Color(char _c) : c(_c) {IsC=true;c2rgba();}
  Color(const char* none) {c='k';c2rgba();}
  double operator()(const int i) {return rgba[i];}
  virtual bool SetColor() {glColor4dv(rgba); return true;}
  virtual bool IsColor() {return true;}
  virtual void Get(ocpl::command&);
  virtual void Set(ocpl::command&);
protected:
  void    c2rgba();
  double  rgba[4];
  char    c;
  bool    IsC;
};

//! Same as color with the option to be "none"
class ColorNone : public Color {
public:
  ColorNone(double r, double g , double b, double a) :
    Color(r,g,b,a) , IsNone(false) {};
  ColorNone(char _c) : Color(_c) , IsNone(false) {};
  ColorNone(const char* none);
  virtual bool SetColor();
  virtual bool IsColor() {return !IsNone;}
  virtual void Get(ocpl::command&);
  virtual void Set(ocpl::command&);
private:
  bool    IsNone;
};


#endif
