// Copyright (C) 2005 Shai Ayal <shaiay@users.sourceforge.net>
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//  
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//  

#include "prop_matrix.h"

//! does not copy the whole matrix
Matrix& Matrix::operator=(const Matrix& right)
{
  if(this== &right) return *this;
  delete Value;
  _nc = right._nc;
  _nr = right._nr;
  Value = new RefPointer<ocpl::Real>(*right.Value);
  return *this;
}

//! does not copy the whole matrix
Matrix::Matrix(const Matrix& mat, int dummy)
{
  _nc = mat._nc;
  _nr = mat._nr;
  Value = new RefPointer<ocpl::Real>(*mat.Value);
}

Matrix::Matrix(const Matrix& mat)
{
  _nc = mat._nc;
  _nr = mat._nr;
  ocpl::Real *tmp = new ocpl::Real[_nr*_nc];

  for(long i=0;i<_nc*_nr;i++) {
    tmp[i] = (*(mat.Value))[i];
  }
  Value = new RefPointer<ocpl::Real>(tmp);
}

//! Beware -- this just copies the pointer, not the data. Do not free
//the pointer, ! Matrix will do it for you when it's not used
Matrix::Matrix(ocpl::Real *v, const long r, const long c)
{
  _nr = r;
  _nc = c;
  if(v)
    Value = new RefPointer<ocpl::Real>(v);
  else 
    Value = new RefPointer<ocpl::Real>( new ocpl::Real[_nr*_nc] );
}

void Matrix::Get(ocpl::command& com)
{
  com.argout(0,ocpl::real,_nr,_nc,reinterpret_cast<char*>(Value->Ptr()));
}

void Matrix::Set(ocpl::command& com)
{
   if(com.argin(2)->id != ocpl::real) {
    ret_error(com,"Value of property must be numerical");
    return;
  }
 
  delete Value;
  _nc = com.argin(2)->nc;
  _nr = com.argin(2)->nr;
  Value = new 
    RefPointer<ocpl::Real>(reinterpret_cast<double*>(com.argin(2)->data));

  // make sure that com does not delete the data
  com.argin(2)->owner=false;
  com.init_argout(0);
}


// Helper funcs

Matrix* Real2Matrix(ocpl::Real x1, ocpl::Real x2)
{
  ocpl::Real* tmp = new ocpl::Real[2];
  tmp[0] = x1;
  tmp[1] = x2;
  return new Matrix(tmp,2,1);
}

Matrix* Real2Matrix(ocpl::Real x1, ocpl::Real x2, ocpl::Real x3)
{
  ocpl::Real* tmp = new ocpl::Real[3] ;
  tmp[0] = x1;
  tmp[1] = x2;
  tmp[2] = x3;
  return new Matrix(tmp,3,1);
}

Matrix* Real2Matrix(ocpl::Real x1, ocpl::Real x2, ocpl::Real x3, ocpl::Real x4)
{
  ocpl::Real* tmp = new ocpl::Real[4];
  tmp[0] = x1;
  tmp[1] = x2;
  tmp[2] = x3;
  tmp[3] = x4;
  return new Matrix(tmp,4,1);
}

