/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "LoadPatchWindow.h"
#include "OmGtk.h"
#include "PatchController.h"
#include "PatchModel.h"
#include "Controller.h"

namespace OmGtk {


LoadPatchWindow::LoadPatchWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& xml)
: Gtk::FileChooserDialog(cobject)
{
	xml->get_widget("load_patch_name_from_file_radio", m_name_from_file_radio);
	xml->get_widget("load_patch_name_from_user_radio", m_name_from_user_radio);
	xml->get_widget("load_patch_name_entry", m_name_entry);
	xml->get_widget("load_patch_poly_from_file_radio", m_poly_from_file_radio);
	xml->get_widget("load_patch_poly_from_user_radio", m_poly_from_user_radio);
	xml->get_widget("load_patch_poly_spinbutton", m_poly_spinbutton);
	xml->get_widget("load_patch_ok_button", m_ok_button);
	xml->get_widget("load_patch_cancel_button", m_cancel_button);
	
	m_name_from_file_radio->signal_toggled().connect(sigc::mem_fun(this, &LoadPatchWindow::name_from_file_selected));
	m_name_from_user_radio->signal_toggled().connect(sigc::mem_fun(this, &LoadPatchWindow::name_from_user_selected));
	m_poly_from_file_radio->signal_toggled().connect(sigc::mem_fun(this, &LoadPatchWindow::poly_from_file_selected));
	m_poly_from_user_radio->signal_toggled().connect(sigc::mem_fun(this, &LoadPatchWindow::poly_from_user_selected));
	m_ok_button->signal_clicked().connect(sigc::mem_fun(this, &LoadPatchWindow::ok_clicked));
	m_cancel_button->signal_clicked().connect(sigc::mem_fun(this, &LoadPatchWindow::cancel_clicked));

	Gtk::FileFilter filt;
	filt.add_pattern("*.om");
	filt.set_name("Om patch files (*.om)");
	set_filter(filt);
}


/** Sets the patch controller for this window and initializes everything.
 *
 * This function MUST be called before using the window in any way!
 */
void
LoadPatchWindow::patch_controller(PatchController* pc)
{
	m_patch_controller = pc;
}


///// Event Handlers //////


void
LoadPatchWindow::name_from_file_selected()
{
	m_name_entry->property_sensitive() = false;
}


void
LoadPatchWindow::name_from_user_selected()
{
	m_name_entry->property_sensitive() = true;
}


void
LoadPatchWindow::poly_from_file_selected()
{
	m_poly_spinbutton->property_sensitive() = false;
}


void
LoadPatchWindow::poly_from_user_selected()
{
	m_poly_spinbutton->property_sensitive() = true;
}


void
LoadPatchWindow::ok_clicked()
{
	// These values are interpreted by load_patch() as "not defined", ie load from file
	string name = "";
	int    poly = 0;
	
	if (m_name_from_user_radio->get_active())
		name = m_name_entry->get_text();

	if (m_poly_from_user_radio->get_active())
		poly = m_poly_spinbutton->get_value_as_int();
	
	PatchModel* pm = new PatchModel((name == "") ? "" : "/"+ name, poly);
	pm->filename(get_filename());
	pm->parent(NULL);
	controller->push_added_patch(pm);
	controller->load_patch(pm);
	
	hide();
}			


void
LoadPatchWindow::cancel_clicked()
{
	hide();
}


} // namespace OmGtk
