/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "RegisterClientEvent.h"
#include "Om.h"
#include "OmApp.h"
#include "OSCReceiver.h"
#include "OSCSender.h"

namespace Om {


RegisterClientEvent::RegisterClientEvent(Request* request, const string& url)
: SlowEvent(request),
  m_url(url),
  m_client_id(-1)
{
}


void
RegisterClientEvent::prepare()
{
	m_client_id = om->osc_receiver()->register_client(m_url);
	
	SlowEvent::prepare();
}


void
RegisterClientEvent::execute(uint sample_offset)
{
	
	SlowEvent::execute(sample_offset);
}


void
RegisterClientEvent::post_process()
{
	if (m_client_id >= 0)
		m_request->respond_ok();
	else
		m_request->respond_error("Unable to register client");

	//om->osc_sender()->send_client_registration(m_url, m_client_id);
}


} // namespace Om

