# -*- coding: utf-8 -*-

# Copyright (C) 2004-2007 Johan Svedberg <johan@svedberg.com>

# This file is part of ontv.

# ontv is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# ontv is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with ontv; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

from gettext import gettext as _

import gtk
import gnome.ui

import GUI
from ontv import NAME, VERSION

class AboutDialog(gtk.AboutDialog):
    def __init__(self):
        gtk.AboutDialog.__init__(self)
        gtk.about_dialog_set_email_hook(self.__url_hook, "mailto:")
        gtk.about_dialog_set_url_hook(self.__url_hook, "")

        self.set_logo_icon_name("ontv")
        self.set_name(NAME)
        self.set_version(VERSION)
        self.set_copyright("Copyright (C) 2004-2007 Johan Svedberg")
        self.set_website("http://johan.svedberg.com/projects/coding/ontv")
        self.set_comments(_("OnTV is a GNOME Applet for monitoring TV programs."))
        self.set_authors(["Johan Svedberg <johan@svedberg.com>"])
        self.set_translator_credits(_("translator-credits"))
        self.set_license("GNU General Public License version 2")
        self.set_artists(["Josef Vybíral <cornelius@vybiral.info>", "Andreas Nilsson <nisses.mail@home.se>", "Ville Pätsi <drc@gnu.org>"])

        self.connect("response", lambda self, *args: self.destroy())

    def __url_hook(self, widget, url, scheme):
        gnome.ui.url_show_on_screen(scheme + url, widget.get_screen())

# vim: set sw=4 et sts=4 tw=79 fo+=l:
