/***************************************************************************
 *   Copyright (C) 2006 by Christian Nitschkowski   *
 *   christian.nitschkowski@kdemail.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <pwd.h>

#include <qdir.h>
#include <qfileinfo.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kprocio.h>

#include "oooqs2detector.h"

OOoQs2Detector* OOoQs2Detector::sp_ptrInstance = 0;

OOoQs2Detector::OOoQs2Detector( QObject* parent )
   : QObject( parent )
{
   OOoQs2Detector::sp_ptrInstance = this;

   passwd* userInfo = getpwuid( geteuid() );
   if( userInfo )
   {
      p_strUser = QString( userInfo->pw_name );
   }
   else
   {
      KMessageBox::error( 0,
         i18n( "Couldn't determine current user account.\n"
         "OpenOffice.org 2 quickstart mode won't work reliable." ) );
   }

   p_procSysGuard << "ksysguardd";

   connect( &p_procSysGuard, SIGNAL( wroteStdin( KProcess* ) ),
      this, SLOT( commandWritten() )
   );

   p_procSysGuard.start( KProcess::NotifyOnExit );
}

QString OOoQs2Detector::detectBinary()
{
   QFileInfo binary;
   QStringList binaryNames;
   const QStringList listPathes = QStringList::split( ":",
      QString( getenv( "PATH" ) )
   );

   binaryNames << "ooffice" << "soffice" << "ooo-wrapper" << "ooo-wrapper2"
      << "ooffice2.0" << "ooo-wrapper2.0";

   for( QStringList::ConstIterator cIt = listPathes.begin();
      cIt != listPathes.end(); ++cIt )
   {
      for( QStringList::ConstIterator cItBin = binaryNames.begin();
         cItBin != binaryNames.end(); ++cItBin )
      {
         binary.setFile( (*cIt) + QDir::separator() + (*cItBin) );
         if( binary.isFile() && binary.isExecutable() )
         {
            KConfig* config = KGlobal::config();
            config->setGroup( "Advanced" );
            config->writeEntry( "DetectedBinary", binary.absFilePath() );
            config->sync();

            return binary.absFilePath();
         }
      }
   }

   return QString::null;
}

int OOoQs2Detector::detectInstance()
{
   QString line;
   int pid = 0;

   if( OOoQs2Detector::sp_ptrInstance == 0 )
   {
      new OOoQs2Detector( KApplication::kApplication() );
   }

   OOoQs2Detector::sp_ptrInstance->p_bCommandWritten = false;

   OOoQs2Detector::sp_ptrInstance->p_procSysGuard.writeStdin( QString( "ps" ) );

   // Wait for the command being written
   while( OOoQs2Detector::sp_ptrInstance->p_bCommandWritten == false )
   {
      usleep( 500 );
      KApplication::kApplication()->processEvents();
   }

   while( OOoQs2Detector::sp_ptrInstance->p_procSysGuard.readln( line ) != -1 )
   {
      // Try to find some occurence of soffice.bin and report it's PID.
      // If there are several soffice.bin's the following ones will be ignored.
      line.replace( '\t', ' ' );
      if( line.section( ' ', 0, 0 ) == "soffice.bin" &&
         line.section( ' ', 11, 11 ) ==
         OOoQs2Detector::sp_ptrInstance->p_strUser )
      {
         line = line.simplifyWhiteSpace();
         pid = line.section( ' ', 1, 1 ).toInt();
         break;
      }
   }

   return pid;
}

void OOoQs2Detector::commandWritten()
{
   p_bCommandWritten = true;
}
