/*
 * keytable8x.c 
 * 
 * Part of the Open21xx assembler toolkit
 * 
 * Copyright (C) 2002 by Keith B. Clifford 
 * 
 * The Open21xx toolkit is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The Open21xx toolkit is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the Open21xx toolkit; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "../defs.h"
#include "symbol.h"
#include "outfile.h"
#include "expression.h"
#include "as21-grammar.h"
#include "keytable.h"

const keyword_t keywords[] = 
{
    { "ABS",        ABS },
    { "AC",         AC },
    { "ADDRESS",    ADDRESS },
    { "AF",         AF },
    { "ALIGN",      ALIGN },
    { "AND",        AND },
    { "AR",         AR },
    { "AR_SAT",     AR_SAT },
    { "ASHIFT",     ASHIFT },
    { "ASTAT",      ASTAT },
    { "AV",         AV },
    { "AV_LATCH",   AV_LATCH },
    { "AX0",        AX0 },
    { "AX1",        AX1 },
    { "AY0",        AY0 },
    { "AY1",        AY1 },
    { "BIT_REV",    BIT_REV },
    { "BY",         BY },
    { "C",          CARRY },
    { "CALL",       CALL },
    { "CE",         CE },
    { "CIRC",       CIRC },
    { "CLRBIT",     CLRBIT },
    { "CNTR",       CNTR },
    { "CODE",       CODE },
    { "DATA",       DATA },
    { "DIS",        DIS },
    { "DIVQ",       DIVQ },
    { "DIVS",       DIVS },
    { "DM",         DM },
    { "DMOVLAY",    DMOVLAY },
    { "DO",         DO },
    { "ENA",        ENA },
    { "EQ",         EQ },
    { "EXP",        EXP },
    { "EXPADJ",     EXPADJ },
    { "EXTERN",     EXTERN },
    { "FILE",       FILE_OBJ },
    { "FL0",        FL0 },
    { "FL1",        FL1 },
    { "FL2",        FL2 },
    { "FLAG_IN",    FLAG_IN },
    { "FLAG_OUT",   FLAG_OUT },
    { "FOREVER",    FOREVER },
    { "G_MODE",     G_MODE },
    { "GE",         GE },
    { "GLOBAL",     GLOBAL },
    { "GT",         GT },
    { "HI",         HI },
    { "HIX",        HIX },
    { "I0",         I0 },
    { "I1",         I1 },
    { "I2",         I2 },
    { "I3",         I3 },
    { "I4",         I4 },
    { "I5",         I5 },
    { "I6",         I6 },
    { "I7",         I7 },
    { "ICNTL",      ICNTL },
    { "IDLE",       IDLE },
    { "IF",         IF },
    { "IFC",        IFC },
    { "IMASK",      IMASK },
    { "INIT24",     INIT24 },
    { "INTS",       INTS },
    { "IO",         IO },
    { "JUMP",       JUMP },
    { "L0",         L0 },
    { "L1",         L1 },
    { "L2",         L2 },
    { "L3",         L3 },
    { "L4",         L4 },
    { "L5",         L5 },
    { "L6",         L6 },
    { "L7",         L7 },
    { "LE",         LE },
    { "LEFTMARGIN", LEFTMARGIN },
    { "LENGTH",     LENGTH },
    { "LIST",       LIST },
    { "LIST_DATA",  LIST_DATA },
    { "LIST_DATFILE", LIST_DATFILE },
    { "LIST_DEFTAB", LIST_DEFTAB },
    { "LIST_LOCTAB", LIST_LOCTAB },
    { "LO",         LO },
    { "LOOP",       LOOP },
    { "LSHIFT",     LSHIFT },
    { "LT",         LT },
    { "M0",         M0 },
    { "M1",         M1 },
    { "M2",         M2 },
    { "M3",         M3 },
    { "M4",         M4 },
    { "M5",         M5 },
    { "M6",         M6 },
    { "M7",         M7 },
    { "M_MODE",     M_MODE },
    { "MF",         MF },
    { "MODIFY",     MODIFY },
    { "MR",         MR },
    { "MR0",        MR0 },
    { "MR1",        MR1 },
    { "MR2",        MR2 },
    { "MSTAT",      MSTAT },
    { "MV",         MV },
    { "MX0",        MX0 },
    { "MX1",        MX1 },
    { "MY0",        MY0 },
    { "MY1",        MY1 },
    { "NE",         NE },
    { "NEG",        NEG },
    { "NEWPAGE",    NEWPAGE },
    { "NOLIST",     NOLIST },
    { "NOLIST_DATA",NOLIST_DATA },
    { "NOLIST_DATFILE", NOLIST_DATFILE },
    { "NONE",       NONE },
    { "NOP",        NOP },
    { "NORM",       NORM },
    { "NOT",        NOT },
    { "OF",         OF },
    { "OR",         OR },
    { "OWRCNTR",    OWRCNTR },
    { "PAGE",       PAGE },
    { "PAGELENGTH", PAGELENGTH },
    { "PAGEWIDTH",  PAGEWIDTH },
    { "PASS",       PASS },
    { "PC",         PC },
    { "PM",         PM },
    { "PMOVLAY",    PMOVLAY },
    { "POP",        POP },
    { "POS",        POS },
    { "PREVIOUS",   PREVIOUS },
    { "PUSH",       PUSH },
    { "PX",         PX },
    { "RESET",      RESET },
    { "RND",        RND },
    { "RTI",        RTI },
    { "RTS",        RTS },
    { "RX0",        RX0 },
    { "RX1",        RX1 },
    { "SAT",        SAT },
    { "SB",         SB },
    { "SE",         SE },
    { "SEC_REG",    SEC_REG },
    { "SECTION",    SECTION },
    { "SET",        SET },
    { "SETBIT",     SETBIT },
    { "SHT_NOBITS", NOBITS },
    { "SHT_PROGBITS", PROGBITS },
    { "SI",         SI },
    { "SR",         SR },
    { "SR0",        SR0 },
    { "SR1",        SR1 },
    { "SS",         SS },
    { "SSTAT",      SSTAT },
    { "STS",        STS },
    { "SU",         SU },
    { "TGLBIT",     TGLBIT },
    { "TIMER",      TIMER },
    { "TOGGLE",     TOGGLE },
    { "TOPPCSTACK", TOPPCSTACK },
    { "TSTBIT",     TSTBIT },
    { "TX0",        TX0 },
    { "TX1",        TX1 },
    { "UNTIL",      UNTIL },
    { "US",         US },
    { "UU",         UU },
    { "VAR",        VAR },
    { "XOR",        XOR }
};

const int keywords_size = sizearray(keywords);
