<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/fileutils.php");
include_once("./functions/logging.php");
include_once("./functions/widgets.php");

function is_import_plugin($plugin)
{
	if(strlen($plugin)>0 && file_exists('./import/'.$plugin.'.php'))
		return TRUE;
	else
		return FALSE;
}

function get_display_import_type($type)
{
	return str_replace('_', ' ', $type);
}

/*
* Return the name of the plugin minus './import/' prefix and '.php' extension,
* or FALSE if no plugin with doctype is found.  This will only ever return
* the first plugin encountered which supports the doctype.
*/
function &get_doctype_import_plugin($doctype)
{
	$handle=opendir('./import');
	while ($file = readdir($handle))
    {
		// Ensure valid plugin name.
		if ( !preg_match("/^\./",$file) && preg_match("/(.*).php$/",$file,$regs))
		{
			include('./import/'.$regs[1].'.php');
			$importPlugin = new $regs[1];
			
			if(strcmp($importPlugin->classname, $regs[1])===0)
			{			
				if($importPlugin->get_plugin_type() == 'xml')
				{
					if($importPlugin->is_doctype_supported($doctype))
					{
						return $importPlugin;
					}
				}
			}
			else
			{
				// Log it so we know what happpened - admin should rectify
				opendb_log('Import class \''.$regs[1].'\' does not have a valid \'var $classname\' ('.$importPlugin->classname.').');
			}
		}
	}
	closedir($handle);
	
	//else
	return NULL;
}

/**
*/
function &get_extension_import_plugin($extension)
{
	$handle=opendir('./import');
	while ($file = readdir($handle))
    {
		// Ensure valid plugin name.
		if ( !preg_match("/^\./",$file) && preg_match("/(.*).php$/",$file,$regs))
		{
			include('./import/'.$regs[1].'.php');
			$importPlugin = new $regs[1];
			
			if(strcmp($importPlugin->classname, $regs[1])===0)
			{
				if($importPlugin->get_plugin_type() == 'row')
				{
					if($importPlugin->is_extension_supported($extension))
					{
						return $importPlugin;
					}
				}
			}
			else
			{
				// Log it so we know what happpened - admin should rectify
				opendb_log('Import class \''.$regs[1].'\' does not have a valid \'var $classname\'.');
			}
		}
	}
	closedir($handle);
	
	//else
	return NULL;
}

/**
	Will return the plugin to use, based on the $http_post_uploadfile_r['name']
	and/or the start of the file itself (available via: $http_post_uploadfile_r['tmp_name'])
*/
function &get_import_plugin($http_post_uploadfile_r, &$error)
{
	global $LANG_VARS;
	
	$extension = strtolower(get_file_ext($http_post_uploadfile_r['name']));
	if(strlen($extension)>0)
	{
		if($extension == 'xml') // We need to find the DOCTYPE for the XML file, so we can assign an XML plugin.
		{
			if(function_exists('xml_parser_create'))
			{
				if(file_exists($http_post_uploadfile_r['tmp_name']))
				{
					if(($fp = @fopen($http_post_uploadfile_r['tmp_name'], 'r')))
					{
						$xml_parser = new StartElementXMLParser();
						$startTag = $xml_parser->getStartElement($fp, $error);
						if(strlen($startTag)>0)
						{
							$importPlugin =& get_doctype_import_plugin($startTag);
							if($importPlugin !== NULL)
							{
								@fclose($fp);
								return $importPlugin;
							}
							else
							{
								@fclose($fp);
								$error = replace_lang_var('doctype', $startTag, $LANG_VARS['doctype_not_supported']);
								return NULL;
							}
						}
						else
						{
							@fclose($fp);
							$error = $LANG_VARS['no_doctype_found'];
							return NULL;
						}
					}
					else
					{
						$error = $LANG_VARS['file_upload_error'];
						return NULL;
					}
				}
				else
				{
					$error = $LANG_VARS['file_upload_error'];
					return NULL;
				}
			}
			else
			{
				$error = $LANG_VARS['xml_import_plugins_not_supported'];
				return NULL;
			}
		}//if($extension == 'xml')
		else
		{
			$importPlugin =& get_extension_import_plugin($extension);
			if($importPlugin !== NULL)
				return $importPlugin;
			else
			{
				$error = replace_lang_var('extension', strtoupper($extension), $LANG_VARS['extension_not_supported']);
				return NULL;
			}
		}
	}
	else
	{
		$error = $LANG_VARS['no_extension_found'];
		return NULL;
	}
}

function listing_item_import_result_row($is_linked_item, $instance_no, $owner_id, $status_type_r, $s_item_type, $title, $category, $category_attr_type_r, $attribute_rs, $errorMsg = NULL)
{
	global $LANG_VARS, $listingObject;

	$listingObject->startRow();

	if(is_not_empty_array($errorMsg) || strlen($errorMsg) > 0)
		$listingObject->addThemeImageColumn("cross.gif");
	else
		$listingObject->addThemeImageColumn("tick.gif");

	$listingObject->addItemTypeImageColumn(
			$s_item_type,
			$is_linked_item);

	// We have to include the title, instance, etc.
	$listingObject->addColumn(
			$title.(is_numeric($instance_no) && $instance_no>1?'&nbsp;#'.$instance_no:''));

	if(is_not_empty_array($errorMsg) || strlen($errorMsg) > 0)
	{
		$listingObject->addColumn(format_error_block($errorMsg, 'smerror'));
	}
	else
	{
		if(!$is_linked_item)
		{
			$listingObject->addThemeImageColumn(
						$status_type_r['img'],
						$status_type_r['description'],
						NULL, //title
						'borrowed_item');
		}
		else
		{
			$listingObject->addColumn('', 1);
		}
	
		// Finally the category column
		$listingObject->addDisplayColumn(
				$category_attr_type_r['s_attribute_type'], 
				$LANG_VARS['category'], 
				'category(%display%)', 
				$category);
		
		$column = '';
		if(is_array($attribute_rs))
		{
			$column .= '<table width=100% border=0 cellpadding=0 cellspacing=0>';
			for($i=0; $i<count($attribute_rs); $i++)
			{
				if(get_function_type($attribute_rs[$i]['display_type']) == 'popupsize' || get_function_type($attribute_rs[$i]['display_type']) == 'hidden' || (strlen($attribute_rs[$i]['display_type'])==0 && get_function_type($attribute_rs[$i]['display_type']) == 'hidden'))
					$attribute_rs[$i]['display_type'] = 'display(%value%)';
				else // get rid of the list-link portion of the display type.
					$attribute_rs[$i]['display_type'] = str_replace('list-link', '', $attribute_rs[$i]['display_type']);
				
				$column .= '<tr><td align=right valign=top width=10%><div class="fineprint">'.str_replace(' ', '&nbsp;', $attribute_rs[$i]['prompt']).':&nbsp;</div></td>'
							.'<td valign=top align=left><div class="fineprint">'.get_display_field($attribute_rs[$i]['s_attribute_type'], $attribute_rs[$i]['prompt'], $attribute_rs[$i]['display_type'], $attribute_rs[$i]['attribute_val'], FALSE).'</div></td>'
							.'</tr>';
			}
			$column .= '</table>';
		}
		$listingObject->addColumn($column);
	}
	$listingObject->endRow();
}//function listing_item_import_result_row($is_linked_item, $instance_no, $owner_id, $status_type_r, $s_item_type, $title, $category, $attribute_rs, $errorMsg = NULL)

function item_import_handler_callback(&$itemImportHandler)
{
	global $LANG_VARS;
	global $cfg_default_status_type_r, 
			$cfg_override_status_type, 
			$cfg_is_trial_run, 
			$cfg_ignore_duplicate_title,
			$v_import_item_id_r;

	$itemObj =& $itemImportHandler->getItem();
	if($itemImportHandler->isItemStructureValid())
	{
		if($itemObj->isItemCompleted())
		{
			$title_attr_type_r = fetch_sfieldtype_item_attribute_type_r($itemObj->getItemType(), 'TITLE');
			$vTitle = filter_input_field($title_attr_type_r['s_attribute_type'], $title_attr_type_r['input_type'], $itemObj->getTitle());
			if(validate_input_field($title_attr_type_r['s_attribute_type'], $title_attr_type_r['prompt'], $title_attr_type_r['input_type'], 'Y', $vTitle, $errors))
			{
				$category_attr_type_r = fetch_sfieldtype_item_attribute_type_r($itemObj->getItemType(), 'CATEGORY');
				$vCategory = filter_input_field($category_attr_type_r['s_attribute_type'], $category_attr_type_r['input_type'], $itemObj->getCategory());
				if(validate_input_field($category_attr_type_r['s_attribute_type'], $category_attr_type_r['prompt'], $category_attr_type_r['input_type'], $category_attr_type_r['compulsory_ind'], $vCategory, $errors))
				{
					$item_instance_rs =& $itemObj->getInstances();
			
					// If at least one owner does not have an instance with the same s_item_type / title 
					// the insert process should proceed.
					$title_does_not_exist_idx = NULL;
					if($cfg_ignore_duplicate_title!==TRUE)
					{
						for($i=0; $i<count($item_instance_rs); $i++)
						{
							if(!is_exists_title($vTitle, $itemObj->getItemType(), $item_instance_rs[$i]['owner_id']))
							{
								$title_does_not_exist_idx[] = $i;
							}
						}
					}
					
					// If we are NOT ignoring titles, and there are no instances where a title is not already a duplicate, then
					// we should NOT insert this item and attributes, but we still have to go through to display the duplicate
					// title error.
					if($cfg_ignore_duplicate_title===TRUE || is_not_empty_array($title_does_not_exist_idx))
					{
						$title_error = FALSE;
						$title_error_detail = NULL;
						
						$attribute_error = FALSE;
						$attribute_error_detail = NULL;
						
						$attr_results = fetch_item_attribute_type_rs($itemObj->getItemType(), TRUE, TRUE);
						if($attr_results)
						{
							$insert_item_attribute_rs = array();
								
							$attribute_rs = $itemObj->getAttributes();
							while($item_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
							{
								if($item_attribute_type_r['s_field_type'] != 'STATUSTYPE' && 
										$item_attribute_type_r['s_field_type'] != 'STATUSCMNT' && 
										$item_attribute_type_r['s_field_type'] != 'DURATION' && 
										$item_attribute_type_r['s_field_type'] != 'CATEGORY' && 
										$item_attribute_type_r['s_field_type'] != 'TITLE' && 
										$item_attribute_type_r['s_field_type'] != 'ITEM_ID')
								{
									$item_attribute_type_r['attribute_val'] = NULL; 
									for($i=0; $i<count($attribute_rs); $i++)
									{
										if(strcasecmp($item_attribute_type_r['s_attribute_type'], $attribute_rs[$i]['s_attribute_type']) === 0 && 
												strcasecmp($item_attribute_type_r['order_no'], $attribute_rs[$i]['order_no']) === 0)
										{
											$item_attribute_type_r['attribute_val'] = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], $attribute_rs[$i]['attribute_val']);
											break;
										}
									}
							
									$errors = NULL;
									if(validate_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['prompt'], $item_attribute_type_r['input_type'], $item_attribute_type_r['compulsory_ind'], $item_attribute_type_r['attribute_val'], $errors))
									{
										if(strlen($item_attribute_type_r['attribute_val'])>0)
										{
											$insert_item_attribute_rs[] = $item_attribute_type_r;
										}
									}
									else
									{
										$attribute_error_detail[] = $errors;
										$attribute_error = TRUE;
										break; // abort ALL inserts for this item.
									}
								}
							}
						}//if($attr_results)
						
						if($attribute_error!==TRUE)
						{
							if($cfg_is_trial_run!==TRUE)
							{
								$item_id = insert_item(NULL, $itemObj->getItemType(), $vTitle, $vCategory);
								if($item_id === FALSE)
								{
									$title_error = TRUE;
									$title_error_detail = mysql_error();
								}
							}
						
							if($title_error!==TRUE)
							{
								$v_import_item_id_r[] = $item_id;
								
								$new_attribute_rs = NULL;
								
								$attribute_rs = $itemObj->getAttributes();
								while(list(,$item_attribute_type_r) = each($insert_item_attribute_rs))
								{
									if($cfg_is_trial_run!==TRUE)
									{
										if(is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
										{
											if(is_array($item_attribute_type_r['attribute_val']))
												$lookup_attribute_val_r = $item_attribute_type_r['attribute_val'];
											else
												$lookup_attribute_val_r[] = $item_attribute_type_r['attribute_val'];
												
											if(insert_lookup_item_attributes($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $lookup_attribute_val_r))
											{
												$new_attribute_rs[] = $item_attribute_type_r;
											}
											else
											{
												$attribute_error_detail[] = mysql_error();
												$attribute_error = TRUE;
											}
										}
										else
										{
											if(insert_item_attribute($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['attribute_val']))
											{
												$new_attribute_rs[] = $item_attribute_type_r;
											}
											else
											{
												$attribute_error_detail[] = mysql_error();
												$attribute_error = TRUE;
											}
										}
									}
									else
									{
										$new_attribute_rs[] = $item_attribute_type_r;
									}
								}

								// assign new attribute array
								$attribute_rs = $new_attribute_rs;
							}//if($title_error!==TRUE)
						}//if(!$attribute_error)
					}//if($cfg_ignore_duplicate_title===TRUE || is_not_empty_array($title_does_not_exist_idx))
					
					$instance_no = 0;
					for($i=0; $i<count($item_instance_rs); $i++)
					{
						if($cfg_override_status_type!==TRUE && strlen($item_instance_rs[$i]['s_status_type'])>0)
						{
							$status_type_r = fetch_status_type_r($item_instance_rs[$i]['s_status_type']);
					
							// If the s_status_type provided is not valid, we will silently ignore it - in favour of
							// the default s_status_type provided.
							if(!is_newitem_status_type_valid($item_instance_rs[$i]['owner_id'], $status_type_r, $errors))
							{
								$status_type_r = $cfg_default_status_type_r;
							}
						}
						else
						{
							$status_type_r = $cfg_default_status_type_r;
						}
					
						// Title already exists for owner, that is to have this instance inserted.
						if($cfg_ignore_duplicate_title===TRUE || array_search2($i, $title_does_not_exist_idx) !== FALSE)
						{
							$instance_no++;
							if($title_error!==TRUE)
							{
								if($attribute_error!==TRUE)
								{
									if($cfg_is_trial_run!==TRUE)
									{
										if(insert_item_instance(
													$item_id,
													$instance_no,
													$status_type_r['s_status_type'], 
													$item_instance_rs[$i]['status_comment'], 
													$item_instance_rs[$i]['borrow_duration'], 
													$item_instance_rs[$i]['owner_id']) !== FALSE)
										{
											// at this point the item has been successfully inserted.
											if($instance_no == 1)
											{
												$v_import_item_id_r[] = $item_id;
											}
											
											listing_item_import_result_row(
													FALSE,
													$instance_no,
													$item_instance_rs[$i]['owner_id'],
													$status_type_r,
													$itemObj->getItemType(), 
													$vTitle,
													$vCategory,
													$category_attr_type_r,
													$attribute_rs);
										}
										else
										{
											listing_item_import_result_row(
													FALSE,
													$instance_no,
													$item_instance_rs[$i]['owner_id'],
													$status_type_r,
													$itemObj->getItemType(), 
													$vTitle,
													$vCategory,
													$category_attr_type_r,
													$attribute_rs, 
													$LANG_VARS['item_not_added'].' ['.mysql_error().']');
										}
									}//if($cfg_is_trial_run!==TRUE)
									else
									{
										listing_item_import_result_row(
													FALSE,
													$instance_no,
													$item_instance_rs[$i]['owner_id'],
													$status_type_r, 
													$itemObj->getItemType(), 
													$vTitle,
													$vCategory,
													$category_attr_type_r,
													$attribute_rs);
									}
								}//if($attribute_error!==TRUE)
								else
								{
									listing_item_import_result_row(
												FALSE,
												$instance_no,
												$item_instance_rs[$i]['owner_id'],
												$status_type_r,
												$itemObj->getItemType(), 
												$vTitle,
												$vCategory,
												$category_attr_type_r,
												$attribute_rs, 
												$attribute_error_detail);
								}
							}//if($title_error!==TRUE)
							else
							{
								listing_item_import_result_row(
												FALSE,
												$instance_no,
												$item_instance_rs[$i]['owner_id'],
												$status_type_r,
												$itemObj->getItemType(), 
												$vTitle,
												$vCategory,
												$category_attr_type_r,
												$attribute_rs,
												$LANG_VARS['item_not_added'].' ['.$title_error_detail.']');
							}
						}//if($cfg_ignore_duplicate_title===TRUE || array_search2($i, $title_does_not_exist_idx) !== FALSE)
						else
						{
							listing_item_import_result_row(
										FALSE,
										NULL,
										$item_instance_rs[$i]['owner_id'],
										$status_type_r,
										$itemObj->getItemType(), 
										$vTitle,
										$vCategory,
										$category_attr_type_r,
										$attribute_rs, 
										$LANG_VARS['title_exists']);
						}
					}//for($i=0; $i<count($item_instance_rs); $i++)
						
					if(($cfg_ignore_duplicate_title===TRUE || is_not_empty_array($title_does_not_exist_idx)) &&
								$title_error!==TRUE && $attribute_error!==TRUE)
					{
						// Now we do the linked items.
						$linked_item_rs =& $itemImportHandler->getLinkedItems();
						if(is_array($linked_item_rs))
						{
							for($i=0; $i<count($linked_item_rs); $i++)
							{
								// now insert each child item.
								$itemObj =& $linked_item_rs[$i];
								
								$title_attr_type_r = fetch_sfieldtype_item_attribute_type_r($itemObj->getItemType(), 'TITLE');
								$vTitle = filter_input_field($title_attr_type_r['s_attribute_type'], $title_attr_type_r['input_type'], $itemObj->getTitle());
								if(validate_input_field($title_attr_type_r['s_attribute_type'], $title_attr_type_r['prompt'], $title_attr_type_r['input_type'], 'Y', $vTitle, $errors))
								{
									$category_attr_type_r = fetch_sfieldtype_item_attribute_type_r($itemObj->getItemType(), 'CATEGORY');
									$vCategory = filter_input_field($category_attr_type_r['s_attribute_type'], $category_attr_type_r['input_type'], $itemObj->getCategory());
									if(validate_input_field($category_attr_type_r['s_attribute_type'], $category_attr_type_r['prompt'], $category_attr_type_r['input_type'], $category_attr_type_r['compulsory_ind'], $vCategory, $errors))
									{
										$title_error = FALSE;
										$title_error_detail = NULL;
						
										$attribute_error = FALSE;
										$attribute_error_detail = NULL;
										
										$attr_results = fetch_item_attribute_type_rs($itemObj->getItemType(), TRUE, TRUE);
										if($attr_results)
										{
											$insert_item_attribute_rs = array();
											
											$attribute_rs = $itemObj->getAttributes();
											while($item_attribute_type_r = mysql_fetch_array($attr_results, MYSQL_ASSOC))
											{
												if($item_attribute_type_r['s_field_type'] != 'STATUSTYPE' && 
															$item_attribute_type_r['s_field_type'] != 'STATUSCMNT' && 
															$item_attribute_type_r['s_field_type'] != 'DURATION' && 
															$item_attribute_type_r['s_field_type'] != 'CATEGORY' && 
															$item_attribute_type_r['s_field_type'] != 'TITLE' && 
															$item_attribute_type_r['s_field_type'] != 'ITEM_ID')
												{
													$item_attribute_type_r['attribute_val'] = NULL;
													for($i=0; $i<count($attribute_rs); $i++)
													{
														if(strcasecmp($item_attribute_type_r['s_attribute_type'], $attribute_rs[$i]['s_attribute_type']) === 0 && 
																strcasecmp($item_attribute_type_r['order_no'], $attribute_rs[$i]['order_no']) === 0)
														{
															$item_attribute_type_r['attribute_val'] = filter_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['input_type'], $attribute_rs[$i]['attribute_val']);
															break;
														}
													}
							
													$errors = NULL;
													if(validate_input_field($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['prompt'], $item_attribute_type_r['input_type'], $item_attribute_type_r['compulsory_ind'], $item_attribute_type_r['attribute_val'], $errors))
													{
														if(strlen($item_attribute_type_r['attribute_val'])>0)
														{
															$insert_item_attribute_rs[] = $item_attribute_type_r;
														}
													}
													else
													{
														$attribute_error_detail[] = $errors;
														$attribute_error = TRUE;
														break; // abort ALL inserts for this item.
													}
												}
											}
										}//if($attr_results)
										
										if($attribute_error!==TRUE)
										{
											if($cfg_is_trial_run!==TRUE)
											{
												$item_id = insert_item($item_id, $itemObj->getItemType(), $vTitle, $vCategory);
												if($item_id !== FALSE)
												{
													// do nothing
												}
												else
												{
													$title_error = TRUE;
													$title_error_detail = mysql_error();
												}
											}
										
											if($title_error!==TRUE)
											{
												while(list(,$item_attribute_type_r) = each($insert_item_attribute_rs))
												{
													if($cfg_is_trial_run!==TRUE)
													{
														if(is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
														{
															if(is_array($item_attribute_type_r['attribute_val']))
																$lookup_attribute_val_r = $item_attribute_type_r['attribute_val'];
															else
																$lookup_attribute_val_r[] = $item_attribute_type_r['attribute_val'];
												
															if(insert_lookup_item_attributes($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $lookup_attribute_val_r))
															{
																$new_attribute_rs[] = $item_attribute_type_r;
															}
															else
															{
																$attribute_error_detail[] = mysql_error();
																$attribute_error = TRUE;
															}
														}
														else
														{
															if(insert_item_attribute($item_id, $item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no'], $item_attribute_type_r['attribute_val']))
															{
																$new_attribute_rs[] = $item_attribute_type_r;
															}
															else
															{
																$attribute_error_detail[] = mysql_error();
																$attribute_error = TRUE;
															}
														}
													}
													else
													{
														$new_attribute_rs[] = $item_attribute_type_r;
													}
												}
												
												// assign new attribute array
												$attribute_rs = $new_attribute_rs;
												
												if($attribute_error!==TRUE)
												{
													// now display results.
													listing_item_import_result_row(
															TRUE,
															NULL, //instance_no
															NULL, //owner_id
															NULL, //status_type_r
															$itemObj->getItemType(), 
															$vTitle,
															$vCategory,
															$category_attr_type_r,
															$attribute_rs);
												}//if($attribute_error!==TRUE)
												else
												{
													listing_item_import_result_row(
															TRUE,
															NULL, //instance_no
															NULL, //owner_id
															NULL, //status_type_r
															$itemObj->getItemType(), 
															$vTitle,
															$vCategory,
															$category_attr_type_r,
															$attribute_rs, 
															$attribute_error_detail);
												}
											}//if($title_error!==TRUE)
											else
											{
												listing_item_import_result_row(
														TRUE,
														NULL, //instance_no
														NULL, //owner_id
														NULL, //status_type_r
														$itemObj->getItemType(), 
														$vTitle,
														$vCategory,
														$category_attr_type_r,
														$attribute_rs, 
														$LANG_VARS['item_not_added'].' ['.$title_error_detail.']');
											}
										}//if($attribute_error!==TRUE)
										else
										{
											listing_item_import_result_row(
													TRUE,
													NULL, //instance_no
													NULL, //owner_id
													NULL, //status_type_r
													$itemObj->getItemType(), 
													$vTitle,
													$vCategory,
													$category_attr_type_r,
													$attribute_rs, 
													$attribute_error_detail);
										}
									}//if(validate_input_field($category_attr_type_r['s_attribute_type'], $category_attr_type_r['prompt'], $category_attr_type_r['input_type'], $category_attr_type_r['compulsory_ind'], $vCategory, $errors))
									else
									{
										listing_item_import_result_row(
												TRUE,
												NULL, //instance_no
												NULL, //owner_id
												NULL, //status_type_r
												$itemObj->getItemType(), 
												$vTitle,
												$vCategory,
												$category_attr_type_r,
												$attribute_rs,
												$errors);
									}
								}//if(validate_input_field($title_attr_type_r['s_attribute_type'], $title_attr_type_r['prompt'], $title_attr_type_r['input_type'], 'Y', $vTitle, $errors))
								else
								{
									listing_item_import_result_row(
											TRUE,
											NULL, //instance_no
											NULL, //owner_id
											NULL, //status_type_r
											$itemObj->getItemType(), 
											$vTitle,
											$vCategory,
											$category_attr_type_r,
											$attribute_rs,
											$errors);
								}
							}//for($i=0; $i<count($linked_item_rs); $i++)
						}//if(is_array($linked_item_rs))
					}//if($title_error!==TRUE && $attribute_error!==TRUE)
				}//if(validate_input_field($category_attr_type_r['s_attribute_type'], $category_attr_type_r['prompt'], $category_attr_type_r['input_type'], $category_attr_type_r['compulsory_ind'], $category, $errors))
				else
				{
					listing_item_import_result_row(
							TRUE,
							NULL, //instance_no
							NULL, //owner_id
							NULL, //status_type_r
							$itemObj->getItemType(), 
							$vTitle,
							$vCategory,
							$category_attr_type_r,
							$attribute_rs,
							$errors);
				}
			}//if(validate_input_field($title_attr_type_r['s_attribute_type'], $title_attr_type_r['prompt'], $title_attr_type_r['input_type'], 'Y', $vTitle, $errors))
			else
			{
				listing_item_import_result_row(
						TRUE,
						NULL, //instance_no
						NULL, //owner_id
						NULL, //status_type_r
						$itemObj->getItemType(), 
						$vTitle,
						$vCategory,
						$category_attr_type_r,
						$attribute_rs,
						$errors);
			}
		}//if($itemObj->isItemCompleted())
		else
		{
			listing_item_import_result_row(
					TRUE,
					NULL, //instance_no
					NULL, //owner_id
					NULL, //status_type_r
					$itemObj->getItemType(), 
					$itemObj->getTitle(),
					$itemObj->getCategory(),
					fetch_sfieldtype_item_attribute_type_r($itemObj->getItemType(), 'CATEGORY'),
					$attribute_rs,
					$itemImportHandler->getErrors());
		}
	}//if($itemImportHandler->isItemStructureValid())
	else
	{
		listing_item_import_result_row(
					TRUE,
					NULL, //instance_no
					NULL, //owner_id
					NULL, //status_type_r
					$itemObj->getItemType(),
					$itemObj->getTitle(),
					$itemObj->getCategory(),
					fetch_sfieldtype_item_attribute_type_r($itemObj->getItemType(), 'CATEGORY'),
					$attribute_rs,
					$itemImportHandler->getErrors());
	}
	
	// do explicit flush
	flush();
}//function item_import_handler_callback(&$itemImportHandler)

//
//
//

/*
* Work out the DocType of the Document, 
*/
class StartElementXMLParser
{
	var $_startElement;

	function getStartElement($fp, &$error)
	{
		// reset it.
		$this->_startElement = NULL;
		
		$parser = xml_parser_create();
	    xml_set_object($parser, $this);
	    xml_set_element_handler($parser, "_startElement", "_endElement");
		
		while ($data = fread($fp, 1024))
		{
			if(strlen($this->_startElement) > 0)
			{
				break;
			}
				
			if(!xml_parse($parser, $data, feof($fp)))
			{
				$error = xml_error_string(xml_get_error_code($parser));
				break;
			}
		}
		xml_parser_free($parser);
		
		return $this->_startElement;
	}

	function _startElement($parser,$name,$attributes)
	{ 
		if(strlen($this->_startElement) == 0)
			$this->_startElement = $name;
	}

	function _endElement($parser,$name)
	{ 
    	// not used
	}
}

class XMLImportPluginHandler
{
	var $itemImportHandler;
	var $importPlugin;
	var $fileHandler;
	
	// We want to send startElement name, attribs and any PCDATA as a 
	// single unit.
	var $_startElementName;
	var $_startElementAttribs;
	var $_characterData;
	
	// stores the first error encountered.
	var $_error;

	function XMLImportPluginHandler(&$itemImportHandler, &$importPlugin, &$fileHandler)
	{
		$this->itemImportHandler =& $itemImportHandler;
		$this->importPlugin =& $importPlugin;
		$this->fileHandler =& $fileHandler;
	}
	
	function handleImport()
	{
		$parser = xml_parser_create();
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, FALSE);
		xml_set_object($parser, $this);
		xml_set_element_handler($parser, "_start_element", "_end_element");
		xml_set_character_data_handler($parser, "_characters");
	
		while ($this->itemImportHandler->isError()!=TRUE && ($data = $this->fileHandler->readLine())!==FALSE)
		{
			if(!xml_parse($parser, $data, $this->fileHandler->isEof()))
			{
				global $LANG_VARS;
				
				$this->_error = replace_lang_vars(array('xml_error_string'=>xml_error_string(xml_get_error_code($parser)), 'xml_error_line'=>xml_get_current_line_number($parser)), $LANG_VARS['xml_error']);
				return FALSE;
			}
		} 
		
		xml_parser_free($parser);
		
		if($this->itemImportHandler->isError())
		{
			// copy the first error in
			$itemImportHandlerErrors =& $this->itemImportHandler->getRawErrors();
			if(is_array($itemImportHandlerErrors))
			{
				$this->_error = $itemImportHandlerErrors[0]['error'];
			}
			
			return FALSE;
		}
		else
			return TRUE;
	}

	function _start_element($parser, $name, $attribs)
	{
		// if any character data waiting to be sent, send it now.
		if(strlen($this->_startElementName)>0)
		{
			$this->importPlugin->start_element(
								$this->_startElementName, 
								$this->_startElementAttribs,
								$this->_characterData);
		}
		
		$this->_startElementName = $name;
		$this->_startElementAttribs = $attribs;
		$this->_characterData = NULL;
	}
	
	function _end_element($parser, $name)
	{
		// if any character data waiting to be sent, send it now.
		if(strlen($this->_startElementName)>0)
		{
			$this->importPlugin->start_element(
								$this->_startElementName, 
								$this->_startElementAttribs,
								trim($this->_characterData));
			
			$this->_startElementName = NULL;
			$this->_startElementAttribs = NULL;
			$this->_characterData = NULL;
		}
		
		$this->importPlugin->end_element($name);
	}
	
	function _characters($parser, $data)
	{
		$this->_characterData .= $data;
	}
	
	function getError()
	{
		return $this->_error;
	}
}

class RowImportPluginHandler
{
	var $itemImportHandler;
	var $importPlugin;
	var $fileHandler;
	var $field_column_r;
	var $field_default_r;
	var $field_initcap_r;
	
	// stores the first error encountered.
	var $_error;

	function RowImportPluginHandler(&$itemImportHandler, &$importPlugin, &$fileHandler, $field_column_r, $field_default_r, $field_initcap_r)
	{
		$this->itemImportHandler =& $itemImportHandler;
		$this->importPlugin =& $importPlugin;
		$this->fileHandler =& $fileHandler;
		$this->field_column_r = $field_column_r;
		$this->field_default_r = $field_default_r;
		$this->field_initcap_r = $field_initcap_r;
	}

	/**
	Will attempt to get the value of the fieldname, via the
	$tokens array and any $fieldname_default.
	*/
	function get_field_value($fieldname, $s_attribute_type, $tokens)
	{
		if(isset($this->field_column_r[$fieldname]) && 
					is_numeric($this->field_column_r[$fieldname]) && 
					strlen($tokens[$this->field_column_r[$fieldname]])>0)
		{
			// Only support INITCAP of actual tokens imported from CSV/DIF file!!!
			if($this->field_initcap_r[$fieldname] == 'true' && !is_array($tokens[$this->field_column_r[$fieldname]]))
				return initcap($tokens[$this->field_column_r[$fieldname]]);
			else
				return $tokens[$this->field_column_r[$fieldname]];
		}
		else if(isset($this->field_default_r[$fieldname]))
		{
			return $this->field_default_r[$fieldname];
		}
		else // no $value to return
			return FALSE;
	}
	
	/*
	* Will call read_header() and ignore it, if is_header_row() == FALSE.  Otherwise will call
	* read_row() and ignore it, if $include_header_row == FALSE
	*/
	function handleImport($include_header_row, $s_item_type)
	{
		// skip the header row if appropriate.
		if($this->importPlugin->is_header_row() !== TRUE || $include_header_row !== TRUE)
		{
			$this->importPlugin->read_header($this->fileHandler, $this->_error);
		}
		
		while( !$this->fileHandler->isEof() && $this->itemImportHandler->isError()!=TRUE && ($read_row_r = $this->importPlugin->read_row($this->fileHandler, $this->_error)) !== FALSE )
		{
			// ensure we have a array that is not empty, or empty except for first element, which is empty.
			// Either no s_item_type restriction applies, or the s_item_type column is the same as
			// the current s_item_type we are processing.
			if((is_not_empty_array($read_row_r) && (count($read_row_r)>1 || strlen($read_row_r[0])>0)) && 
						(!is_numeric($this->field_column_r['s_item_type']) || 
						strlen($read_row_r[$this->field_column_r['s_item_type']])==0 || 
						strcasecmp($read_row_r[$this->field_column_r['s_item_type']], $s_item_type)===0))
			{
				// lets start the typing off correctly.
				$this->itemImportHandler->startItem($s_item_type);
			
				// Now do the title.
				$title_attr_type_r = fetch_sfieldtype_item_attribute_type_r($s_item_type, 'TITLE');
				$title = $this->get_field_value(get_field_name($title_attr_type_r['s_attribute_type'], $title_attr_type_r['order_no']), NULL, $read_row_r);
				$this->itemImportHandler->setTitle($title);
			
				// get the category.
				$category_attr_type_r = fetch_sfieldtype_item_attribute_type_r($s_item_type, 'CATEGORY');
				$category = $this->get_field_value(get_field_name($category_attr_type_r['s_attribute_type'], $category_attr_type_r['order_no']), $category_attr_type_r['s_attribute_type'], $read_row_r);
				
				// Replace the '/' or '\' separator with a space instead. Category must be an array.
				$this->itemImportHandler->setCategory(trim_explode(' ', str_replace(array('/','\\',','), ' ', $category)));
			
				// We need to insert all the attributes as well. Do not need full records.
				$results = fetch_item_attribute_type_rs($s_item_type, TRUE);
				if($results)
				{	
					while($item_attribute_type_r = mysql_fetch_array($results))
					{
						if($item_attribute_type_r['s_field_type'] != 'CATEGORY' && 
									$item_attribute_type_r['s_field_type'] != 'TITLE' && 
									$item_attribute_type_r['s_field_type'] != 'STATUSTYPE' && 
									$item_attribute_type_r['s_field_type'] != 'STATUSCMNT' && 
									$item_attribute_type_r['s_field_type'] != 'DURATION' &&
									$item_attribute_type_r['s_field_type'] != 'ITEM_ID')
						{
							$value = $this->get_field_value(get_field_name($item_attribute_type_r['s_attribute_type'], $item_attribute_type_r['order_no']), $item_attribute_type_r['s_attribute_type'], $read_row_r);
							if($this->itemImportHandler->is_lookup_attribute_type($item_attribute_type_r['s_attribute_type']))
							{
								// row based are comma delimited.
								$values_r = trim_explode(',', $value);
								if(is_not_empty_array($values_r))
								{
									$this->itemImportHandler->itemAttribute(
													$item_attribute_type_r['s_attribute_type'], 
													$item_attribute_type_r['order_no'], 
													$values_r);
								}
							}
							else
							{
								// value must be not empty.
								if(strlen($value)>0)
								{
									$this->itemImportHandler->itemAttribute(
													$item_attribute_type_r['s_attribute_type'], 
													$item_attribute_type_r['order_no'], 
													$value);
								}
							}
						}
					}
					mysql_free_result($results);
				}//if($results)
			
				$status_attr_type_r = fetch_sfieldtype_item_attribute_type_r($s_item_type, 'STATUSTYPE');
				$s_status_type = $this->get_field_value(get_field_name($status_attr_type_r['s_attribute_type'], $status_attr_type_r['order_no']), $status_attr_type_r['s_attribute_type'], $read_row_r);

				$status_cmnt_attr_type_r = fetch_sfieldtype_item_attribute_type_r($s_item_type, 'STATUSCMNT');
				$status_comment = $this->get_field_value(get_field_name($status_cmnt_attr_type_r['s_attribute_type'], $status_cmnt_attr_type_r['order_no']), $status_cmnt_attr_type_r['s_attribute_type'], $read_row_r);
						
				$duration_attr_type_r = fetch_sfieldtype_item_attribute_type_r($s_item_type, 'DURATION');
				$borrow_duration = $this->get_field_value(get_field_name($duration_attr_type_r['s_attribute_type'], $duration_attr_type_r['order_no']), $duration_attr_type_r['s_attribute_type'], $read_row_r);

				// We are only supporting instances, at this point - at some time in the future this
				// functionality may be augmented to supported linked items as well - as long as they
				// are the same s_item_type as the parent.
				$this->itemImportHandler->itemInstance($s_status_type, $status_comment, $borrow_duration);
			
				// Now end the item.
				$this->itemImportHandler->endItem();
			}
		}
		
		if($this->itemImportHandler->isError())
		{
			// copy the first error in
			$itemImportHandlerErrors =& $this->itemImportHandler->getRawErrors();
			if(is_array($itemImportHandlerErrors))
			{
				$this->_error = $itemImportHandlerErrors[0]['error'];
			}
			
			return FALSE;
		}
		else
			return TRUE;
	}
	
	function getError()
	{
		return $this->_error;
	}
}

class WrapperFileHandler
{
	var $_fileHandle;
	
	function WrapperFileHandler($fileHandle)
	{
		$this->_fileHandle = $fileHandle;
	}
	
	function isEof()
	{
		return feof($this->_fileHandle);
	}
	
	function readLine()
	{
		if(!$this->isEof())
		{
			return fgets($this->_fileHandle, 4096);
		}
		else
		{
			return FALSE;
		}
	}
}

class StringFileHandler
{
	var $_content;
	var $_content_length;
	var $_offset;
	
	var $_line_ending;
	var $_line_ending_length;
	
	function StringFileHandler($content)
	{
		$this->_content = $content;
		$this->_content_length = strlen($content);
		$this->_offset = 0;
		
		// lets ascertain the operating system of this
		// file by looking for first line ending.
		if(strpos($this->_content, "\r\n")!==FALSE)
		{
			$this->_line_ending = "\r\n";
			$this->_line_ending_length = 2;
		}
		else if(strpos($this->_content, "\n")!==FALSE)
		{
			$this->_line_ending = "\n";
			$this->_line_ending_length = 1;
		}
		else if(strpos($this->_content, "\r")!==FALSE)
		{
			$this->_line_ending = "\r";
			$this->_line_ending_length = 1;
		}
		else
			$this->_line_ending = NULL; // no line ending in this file.
	}
	
	function isEof()
	{
		if($this->_offset >= $this->_content_length)
			return TRUE;
		else
			return FALSE;
	}
	
	/**
	* Handles all operating system line endings:
	* 	Macintosh - \r
	* 	Windows \r\n
	* 	Unix \n
	* 
	* If the line is empty, except for the line ending, this function will
	* return NULL.  It will return FALSE when no more data to read.
	*/
	function readLine()
	{
		if(!$this->isEof())
		{
			if($this->_line_ending!==NULL)
			{
				if( ($idx = strpos($this->_content, $this->_line_ending, $this->_offset)) !== FALSE)
				{
					if($idx > $this->_offset)
					{
						$line = substr($this->_content, $this->_offset, $idx-$this->_offset);
						$this->_offset = $idx + $this->_line_ending_length;
						return $line;
					}
					else
					{
						$this->_offset++;
						return NULL;
					}
				}
				else
				{
					$line = substr ($this->_content, $this->_offset);
					$this->_offset = $this->_content_length;
				
					// last line.
					return $line;
				}
			}
			else
			{
				// no lines, return all content.
				$this->_offset = $this->_content_length;
				return $this->_content;
			}
		}
		
		//else - no line
		return FALSE;
	}
}
?>