<?php
/* 	
	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/patchutils.php");
include_once("./functions/database.php");

// This must be first - includes config.php
require_once("./include/begin.inc.php");
	
include_once("./include/language.php");
include_once("./include/theme.php");
	
session_start();

if($CONFIG_VARS['site.enable']!==FALSE)
{
	if($CONFIG_VARS['patch.upgrade_check']!==FALSE)
	{
		if(is_exists_opendb_database($mysql_error))
		{
			// TODO: Do a complete check of all areas of the system to make sure they are up to date.
			$result = is_opendb_upto_date();
			if($result === TRUE)
			{
				echo _theme_index();
			}
			else if($result === "INSTALL")
			{
				echo _theme_header('OpenDb Installation', FALSE);
				echo _theme_error('OpenDb is not installed on the configured opendb database ('.$CONFIG_VARS['db_server.dbname'].'@'.$CONFIG_VARS['db_server.host'].')<br><br>Use the Patch Facility <a href="patch.php?from=install&type=install">New Install</a> option.');
				echo _theme_footer();
			}
			else if($result === "PARTIAL_INSTALL")
			{
				echo _theme_header('OpenDb Installation', FALSE);
				echo _theme_error('OpenDb must be upgraded to '.$CONFIG_VARS['site.version'].' on the configured opendb database ('.$CONFIG_VARS['db_server.dbname'].'@'.$CONFIG_VARS['db_server.host'].')<br><br>Use the <a href="patch.php">Patch Facility</a> with the appropriate upgrade option.');
				echo _theme_footer();
			}
		}//if(is_exists_opendb_database($mysql_error))
		else
		{
			echo _theme_header('OpenDb Installation', FALSE);
			echo _theme_error('The configured opendb database ('.$CONFIG_VARS['db_server.dbname'].'@'.$CONFIG_VARS['db_server.host'].') does not exist or is not accessible ('.$mysql_error.')<br><br>Refer to the <a href="docs/INSTALL">INSTALL</a> document for more information.');
			echo _theme_footer();
		}
	} // no upgrade check, so just do default functionality.
	else
	{
		echo _theme_index();
	}
}//if($CONFIG_VARS['site.enable']!==FALSE)
else
{
	echo _theme_header($LANG_VARS['site_is_disabled'], FALSE);
	echo _theme_error($LANG_VARS['site_is_disabled']);
	echo _theme_footer();
}
// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>